/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.OrdersCreateRequestBody;
import io.voucherify.client.model.OrdersCreateResponseBody;
import io.voucherify.client.model.OrdersExportCreateRequestBody;
import io.voucherify.client.model.OrdersExportCreateResponseBody;
import io.voucherify.client.model.OrdersGetResponseBody;
import io.voucherify.client.model.OrdersImportCreateRequestBodyItem;
import io.voucherify.client.model.OrdersImportCreateResponseBody;
import io.voucherify.client.model.OrdersListResponseBody;
import io.voucherify.client.model.OrdersUpdateRequestBody;
import io.voucherify.client.model.OrdersUpdateResponseBody;
import io.voucherify.client.model.ParameterOrderListOrders;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class OrdersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrdersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrdersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createOrderCall(OrdersCreateRequestBody ordersCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrdersCreateRequestBody localVarPostBody = ordersCreateRequestBody;
        String localVarPath = "/v1/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderValidateBeforeCall(OrdersCreateRequestBody ordersCreateRequestBody, ApiCallback _callback) throws ApiException {
        return this.createOrderCall(ordersCreateRequestBody, _callback);
    }

    public OrdersCreateResponseBody createOrder(OrdersCreateRequestBody ordersCreateRequestBody) throws ApiException {
        ApiResponse<OrdersCreateResponseBody> localVarResp = this.createOrderWithHttpInfo(ordersCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<OrdersCreateResponseBody> createOrderWithHttpInfo(OrdersCreateRequestBody ordersCreateRequestBody) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(ordersCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<OrdersCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOrderAsync(OrdersCreateRequestBody ordersCreateRequestBody, ApiCallback<OrdersCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(ordersCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<OrdersCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createOrderExportCall(OrdersExportCreateRequestBody ordersExportCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrdersExportCreateRequestBody localVarPostBody = ordersExportCreateRequestBody;
        String localVarPath = "/v1/orders/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderExportValidateBeforeCall(OrdersExportCreateRequestBody ordersExportCreateRequestBody, ApiCallback _callback) throws ApiException {
        return this.createOrderExportCall(ordersExportCreateRequestBody, _callback);
    }

    public OrdersExportCreateResponseBody createOrderExport(OrdersExportCreateRequestBody ordersExportCreateRequestBody) throws ApiException {
        ApiResponse<OrdersExportCreateResponseBody> localVarResp = this.createOrderExportWithHttpInfo(ordersExportCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<OrdersExportCreateResponseBody> createOrderExportWithHttpInfo(OrdersExportCreateRequestBody ordersExportCreateRequestBody) throws ApiException {
        Call localVarCall = this.createOrderExportValidateBeforeCall(ordersExportCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<OrdersExportCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOrderExportAsync(OrdersExportCreateRequestBody ordersExportCreateRequestBody, ApiCallback<OrdersExportCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createOrderExportValidateBeforeCall(ordersExportCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<OrdersExportCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrderCall(String orderId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/{orderId}".replace("{orderId}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderValidateBeforeCall(String orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrder(Async)");
        }
        return this.getOrderCall(orderId, _callback);
    }

    public OrdersGetResponseBody getOrder(String orderId) throws ApiException {
        ApiResponse<OrdersGetResponseBody> localVarResp = this.getOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<OrdersGetResponseBody> getOrderWithHttpInfo(String orderId) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<OrdersGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrderAsync(String orderId, ApiCallback<OrdersGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<OrdersGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importOrdersCall(List<OrdersImportCreateRequestBodyItem> ordersImportCreateRequestBodyItem, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<OrdersImportCreateRequestBodyItem> localVarPostBody = ordersImportCreateRequestBodyItem;
        String localVarPath = "/v1/orders/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importOrdersValidateBeforeCall(List<OrdersImportCreateRequestBodyItem> ordersImportCreateRequestBodyItem, ApiCallback _callback) throws ApiException {
        return this.importOrdersCall(ordersImportCreateRequestBodyItem, _callback);
    }

    public OrdersImportCreateResponseBody importOrders(List<OrdersImportCreateRequestBodyItem> ordersImportCreateRequestBodyItem) throws ApiException {
        ApiResponse<OrdersImportCreateResponseBody> localVarResp = this.importOrdersWithHttpInfo(ordersImportCreateRequestBodyItem);
        return localVarResp.getData();
    }

    public ApiResponse<OrdersImportCreateResponseBody> importOrdersWithHttpInfo(List<OrdersImportCreateRequestBodyItem> ordersImportCreateRequestBodyItem) throws ApiException {
        Call localVarCall = this.importOrdersValidateBeforeCall(ordersImportCreateRequestBodyItem, null);
        Type localVarReturnType = new TypeToken<OrdersImportCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importOrdersAsync(List<OrdersImportCreateRequestBodyItem> ordersImportCreateRequestBodyItem, ApiCallback<OrdersImportCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.importOrdersValidateBeforeCall(ordersImportCreateRequestBodyItem, _callback);
        Type localVarReturnType = new TypeToken<OrdersImportCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listOrdersCall(Integer limit, Integer page, ParameterOrderListOrders order, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOrdersValidateBeforeCall(Integer limit, Integer page, ParameterOrderListOrders order, ApiCallback _callback) throws ApiException {
        return this.listOrdersCall(limit, page, order, _callback);
    }

    public OrdersListResponseBody listOrders(Integer limit, Integer page, ParameterOrderListOrders order) throws ApiException {
        ApiResponse<OrdersListResponseBody> localVarResp = this.listOrdersWithHttpInfo(limit, page, order);
        return localVarResp.getData();
    }

    public ApiResponse<OrdersListResponseBody> listOrdersWithHttpInfo(Integer limit, Integer page, ParameterOrderListOrders order) throws ApiException {
        Call localVarCall = this.listOrdersValidateBeforeCall(limit, page, order, null);
        Type localVarReturnType = new TypeToken<OrdersListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOrdersAsync(Integer limit, Integer page, ParameterOrderListOrders order, ApiCallback<OrdersListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listOrdersValidateBeforeCall(limit, page, order, _callback);
        Type localVarReturnType = new TypeToken<OrdersListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateOrderCall(String orderId, OrdersUpdateRequestBody ordersUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrdersUpdateRequestBody localVarPostBody = ordersUpdateRequestBody;
        String localVarPath = "/v1/orders/{orderId}".replace("{orderId}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderValidateBeforeCall(String orderId, OrdersUpdateRequestBody ordersUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling updateOrder(Async)");
        }
        return this.updateOrderCall(orderId, ordersUpdateRequestBody, _callback);
    }

    public OrdersUpdateResponseBody updateOrder(String orderId, OrdersUpdateRequestBody ordersUpdateRequestBody) throws ApiException {
        ApiResponse<OrdersUpdateResponseBody> localVarResp = this.updateOrderWithHttpInfo(orderId, ordersUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<OrdersUpdateResponseBody> updateOrderWithHttpInfo(String orderId, OrdersUpdateRequestBody ordersUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateOrderValidateBeforeCall(orderId, ordersUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<OrdersUpdateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateOrderAsync(String orderId, OrdersUpdateRequestBody ordersUpdateRequestBody, ApiCallback<OrdersUpdateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateOrderValidateBeforeCall(orderId, ordersUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<OrdersUpdateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

