/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.ParameterOrder;
import io.voucherify.client.model.ProductCollectionsCreateRequestBody;
import io.voucherify.client.model.ProductCollectionsCreateResponseBody;
import io.voucherify.client.model.ProductCollectionsGetResponseBody;
import io.voucherify.client.model.ProductCollectionsListResponseBody;
import io.voucherify.client.model.ProductCollectionsProductsListResponseBody;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProductCollectionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductCollectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductCollectionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProductCollectionCall(ProductCollectionsCreateRequestBody productCollectionsCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductCollectionsCreateRequestBody localVarPostBody = productCollectionsCreateRequestBody;
        String localVarPath = "/v1/product-collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductCollectionValidateBeforeCall(ProductCollectionsCreateRequestBody productCollectionsCreateRequestBody, ApiCallback _callback) throws ApiException {
        return this.createProductCollectionCall(productCollectionsCreateRequestBody, _callback);
    }

    public ProductCollectionsCreateResponseBody createProductCollection(ProductCollectionsCreateRequestBody productCollectionsCreateRequestBody) throws ApiException {
        ApiResponse<ProductCollectionsCreateResponseBody> localVarResp = this.createProductCollectionWithHttpInfo(productCollectionsCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductCollectionsCreateResponseBody> createProductCollectionWithHttpInfo(ProductCollectionsCreateRequestBody productCollectionsCreateRequestBody) throws ApiException {
        Call localVarCall = this.createProductCollectionValidateBeforeCall(productCollectionsCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductCollectionsCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProductCollectionAsync(ProductCollectionsCreateRequestBody productCollectionsCreateRequestBody, ApiCallback<ProductCollectionsCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createProductCollectionValidateBeforeCall(productCollectionsCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductCollectionsCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProductCollectionCall(String productCollectionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/product-collections/{productCollectionId}".replace("{productCollectionId}", this.localVarApiClient.escapeString(productCollectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductCollectionValidateBeforeCall(String productCollectionId, ApiCallback _callback) throws ApiException {
        if (productCollectionId == null) {
            throw new ApiException("Missing the required parameter 'productCollectionId' when calling deleteProductCollection(Async)");
        }
        return this.deleteProductCollectionCall(productCollectionId, _callback);
    }

    public void deleteProductCollection(String productCollectionId) throws ApiException {
        this.deleteProductCollectionWithHttpInfo(productCollectionId);
    }

    public ApiResponse<Void> deleteProductCollectionWithHttpInfo(String productCollectionId) throws ApiException {
        Call localVarCall = this.deleteProductCollectionValidateBeforeCall(productCollectionId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProductCollectionAsync(String productCollectionId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProductCollectionValidateBeforeCall(productCollectionId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProductCollectionCall(String productCollectionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/product-collections/{productCollectionId}".replace("{productCollectionId}", this.localVarApiClient.escapeString(productCollectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductCollectionValidateBeforeCall(String productCollectionId, ApiCallback _callback) throws ApiException {
        if (productCollectionId == null) {
            throw new ApiException("Missing the required parameter 'productCollectionId' when calling getProductCollection(Async)");
        }
        return this.getProductCollectionCall(productCollectionId, _callback);
    }

    public ProductCollectionsGetResponseBody getProductCollection(String productCollectionId) throws ApiException {
        ApiResponse<ProductCollectionsGetResponseBody> localVarResp = this.getProductCollectionWithHttpInfo(productCollectionId);
        return localVarResp.getData();
    }

    public ApiResponse<ProductCollectionsGetResponseBody> getProductCollectionWithHttpInfo(String productCollectionId) throws ApiException {
        Call localVarCall = this.getProductCollectionValidateBeforeCall(productCollectionId, null);
        Type localVarReturnType = new TypeToken<ProductCollectionsGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductCollectionAsync(String productCollectionId, ApiCallback<ProductCollectionsGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getProductCollectionValidateBeforeCall(productCollectionId, _callback);
        Type localVarReturnType = new TypeToken<ProductCollectionsGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductCollectionsCall(Integer limit, Integer page, ParameterOrder order, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/product-collections";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductCollectionsValidateBeforeCall(Integer limit, Integer page, ParameterOrder order, ApiCallback _callback) throws ApiException {
        return this.listProductCollectionsCall(limit, page, order, _callback);
    }

    public ProductCollectionsListResponseBody listProductCollections(Integer limit, Integer page, ParameterOrder order) throws ApiException {
        ApiResponse<ProductCollectionsListResponseBody> localVarResp = this.listProductCollectionsWithHttpInfo(limit, page, order);
        return localVarResp.getData();
    }

    public ApiResponse<ProductCollectionsListResponseBody> listProductCollectionsWithHttpInfo(Integer limit, Integer page, ParameterOrder order) throws ApiException {
        Call localVarCall = this.listProductCollectionsValidateBeforeCall(limit, page, order, null);
        Type localVarReturnType = new TypeToken<ProductCollectionsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductCollectionsAsync(Integer limit, Integer page, ParameterOrder order, ApiCallback<ProductCollectionsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listProductCollectionsValidateBeforeCall(limit, page, order, _callback);
        Type localVarReturnType = new TypeToken<ProductCollectionsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductsInCollectionCall(String productCollectionId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startingAfter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/product-collections/{productCollectionId}/products".replace("{productCollectionId}", this.localVarApiClient.escapeString(productCollectionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (startingAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("starting_after", startingAfter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductsInCollectionValidateBeforeCall(String productCollectionId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startingAfter, ApiCallback _callback) throws ApiException {
        if (productCollectionId == null) {
            throw new ApiException("Missing the required parameter 'productCollectionId' when calling listProductsInCollection(Async)");
        }
        return this.listProductsInCollectionCall(productCollectionId, limit, page, order, startingAfter, _callback);
    }

    public ProductCollectionsProductsListResponseBody listProductsInCollection(String productCollectionId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startingAfter) throws ApiException {
        ApiResponse<ProductCollectionsProductsListResponseBody> localVarResp = this.listProductsInCollectionWithHttpInfo(productCollectionId, limit, page, order, startingAfter);
        return localVarResp.getData();
    }

    public ApiResponse<ProductCollectionsProductsListResponseBody> listProductsInCollectionWithHttpInfo(String productCollectionId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startingAfter) throws ApiException {
        Call localVarCall = this.listProductsInCollectionValidateBeforeCall(productCollectionId, limit, page, order, startingAfter, null);
        Type localVarReturnType = new TypeToken<ProductCollectionsProductsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductsInCollectionAsync(String productCollectionId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startingAfter, ApiCallback<ProductCollectionsProductsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listProductsInCollectionValidateBeforeCall(productCollectionId, limit, page, order, startingAfter, _callback);
        Type localVarReturnType = new TypeToken<ProductCollectionsProductsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

