/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.ParameterOrder;
import io.voucherify.client.model.ProductsCreateRequestBody;
import io.voucherify.client.model.ProductsCreateResponseBody;
import io.voucherify.client.model.ProductsGetResponseBody;
import io.voucherify.client.model.ProductsImportCsvCreateResponseBody;
import io.voucherify.client.model.ProductsListResponseBody;
import io.voucherify.client.model.ProductsMetadataUpdateInBulkRequestBody;
import io.voucherify.client.model.ProductsMetadataUpdateInBulkResponseBody;
import io.voucherify.client.model.ProductsSkusCreateRequestBody;
import io.voucherify.client.model.ProductsSkusCreateResponseBody;
import io.voucherify.client.model.ProductsSkusListResponseBody;
import io.voucherify.client.model.ProductsSkusUpdateRequestBody;
import io.voucherify.client.model.ProductsSkusUpdateResponseBody;
import io.voucherify.client.model.ProductsUpdateInBulkRequestBody;
import io.voucherify.client.model.ProductsUpdateInBulkResponseBody;
import io.voucherify.client.model.ProductsUpdateRequestBody;
import io.voucherify.client.model.ProductsUpdateResponseBody;
import io.voucherify.client.model.SkusGetResponseBody;
import io.voucherify.client.model.SkusImportCsvCreateResponseBody;
import java.io.File;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ProductsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProductCall(ProductsCreateRequestBody productsCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductsCreateRequestBody localVarPostBody = productsCreateRequestBody;
        String localVarPath = "/v1/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductValidateBeforeCall(ProductsCreateRequestBody productsCreateRequestBody, ApiCallback _callback) throws ApiException {
        return this.createProductCall(productsCreateRequestBody, _callback);
    }

    public ProductsCreateResponseBody createProduct(ProductsCreateRequestBody productsCreateRequestBody) throws ApiException {
        ApiResponse<ProductsCreateResponseBody> localVarResp = this.createProductWithHttpInfo(productsCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsCreateResponseBody> createProductWithHttpInfo(ProductsCreateRequestBody productsCreateRequestBody) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(productsCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductsCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProductAsync(ProductsCreateRequestBody productsCreateRequestBody, ApiCallback<ProductsCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(productsCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductsCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSkuCall(String productId, ProductsSkusCreateRequestBody productsSkusCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductsSkusCreateRequestBody localVarPostBody = productsSkusCreateRequestBody;
        String localVarPath = "/v1/products/{productId}/skus".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSkuValidateBeforeCall(String productId, ProductsSkusCreateRequestBody productsSkusCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling createSku(Async)");
        }
        return this.createSkuCall(productId, productsSkusCreateRequestBody, _callback);
    }

    public ProductsSkusCreateResponseBody createSku(String productId, ProductsSkusCreateRequestBody productsSkusCreateRequestBody) throws ApiException {
        ApiResponse<ProductsSkusCreateResponseBody> localVarResp = this.createSkuWithHttpInfo(productId, productsSkusCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsSkusCreateResponseBody> createSkuWithHttpInfo(String productId, ProductsSkusCreateRequestBody productsSkusCreateRequestBody) throws ApiException {
        Call localVarCall = this.createSkuValidateBeforeCall(productId, productsSkusCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductsSkusCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSkuAsync(String productId, ProductsSkusCreateRequestBody productsSkusCreateRequestBody, ApiCallback<ProductsSkusCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.createSkuValidateBeforeCall(productId, productsSkusCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductsSkusCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProductCall(String productId, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductValidateBeforeCall(String productId, Boolean force, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling deleteProduct(Async)");
        }
        return this.deleteProductCall(productId, force, _callback);
    }

    public void deleteProduct(String productId, Boolean force) throws ApiException {
        this.deleteProductWithHttpInfo(productId, force);
    }

    public ApiResponse<Void> deleteProductWithHttpInfo(String productId, Boolean force) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(productId, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProductAsync(String productId, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(productId, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteSkuCall(String productId, String skuId, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/skus/{skuId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString())).replace("{skuId}", this.localVarApiClient.escapeString(skuId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSkuValidateBeforeCall(String productId, String skuId, Boolean force, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling deleteSku(Async)");
        }
        if (skuId == null) {
            throw new ApiException("Missing the required parameter 'skuId' when calling deleteSku(Async)");
        }
        return this.deleteSkuCall(productId, skuId, force, _callback);
    }

    public void deleteSku(String productId, String skuId, Boolean force) throws ApiException {
        this.deleteSkuWithHttpInfo(productId, skuId, force);
    }

    public ApiResponse<Void> deleteSkuWithHttpInfo(String productId, String skuId, Boolean force) throws ApiException {
        Call localVarCall = this.deleteSkuValidateBeforeCall(productId, skuId, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSkuAsync(String productId, String skuId, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSkuValidateBeforeCall(productId, skuId, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProductCall(String productId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductValidateBeforeCall(String productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProduct(Async)");
        }
        return this.getProductCall(productId, _callback);
    }

    public ProductsGetResponseBody getProduct(String productId) throws ApiException {
        ApiResponse<ProductsGetResponseBody> localVarResp = this.getProductWithHttpInfo(productId);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsGetResponseBody> getProductWithHttpInfo(String productId) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(productId, null);
        Type localVarReturnType = new TypeToken<ProductsGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProductAsync(String productId, ApiCallback<ProductsGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(productId, _callback);
        Type localVarReturnType = new TypeToken<ProductsGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSkuCall(String skuId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/skus/{skuId}".replace("{skuId}", this.localVarApiClient.escapeString(skuId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSkuValidateBeforeCall(String skuId, ApiCallback _callback) throws ApiException {
        if (skuId == null) {
            throw new ApiException("Missing the required parameter 'skuId' when calling getSku(Async)");
        }
        return this.getSkuCall(skuId, _callback);
    }

    public SkusGetResponseBody getSku(String skuId) throws ApiException {
        ApiResponse<SkusGetResponseBody> localVarResp = this.getSkuWithHttpInfo(skuId);
        return localVarResp.getData();
    }

    public ApiResponse<SkusGetResponseBody> getSkuWithHttpInfo(String skuId) throws ApiException {
        Call localVarCall = this.getSkuValidateBeforeCall(skuId, null);
        Type localVarReturnType = new TypeToken<SkusGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSkuAsync(String skuId, ApiCallback<SkusGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getSkuValidateBeforeCall(skuId, _callback);
        Type localVarReturnType = new TypeToken<SkusGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importProductsUsingCsvCall(File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/importCSV";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importProductsUsingCsvValidateBeforeCall(File _file, ApiCallback _callback) throws ApiException {
        return this.importProductsUsingCsvCall(_file, _callback);
    }

    public ProductsImportCsvCreateResponseBody importProductsUsingCsv(File _file) throws ApiException {
        ApiResponse<ProductsImportCsvCreateResponseBody> localVarResp = this.importProductsUsingCsvWithHttpInfo(_file);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsImportCsvCreateResponseBody> importProductsUsingCsvWithHttpInfo(File _file) throws ApiException {
        Call localVarCall = this.importProductsUsingCsvValidateBeforeCall(_file, null);
        Type localVarReturnType = new TypeToken<ProductsImportCsvCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importProductsUsingCsvAsync(File _file, ApiCallback<ProductsImportCsvCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.importProductsUsingCsvValidateBeforeCall(_file, _callback);
        Type localVarReturnType = new TypeToken<ProductsImportCsvCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call importSkusUsingCsvCall(File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/skus/importCSV";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importSkusUsingCsvValidateBeforeCall(File _file, ApiCallback _callback) throws ApiException {
        return this.importSkusUsingCsvCall(_file, _callback);
    }

    public SkusImportCsvCreateResponseBody importSkusUsingCsv(File _file) throws ApiException {
        ApiResponse<SkusImportCsvCreateResponseBody> localVarResp = this.importSkusUsingCsvWithHttpInfo(_file);
        return localVarResp.getData();
    }

    public ApiResponse<SkusImportCsvCreateResponseBody> importSkusUsingCsvWithHttpInfo(File _file) throws ApiException {
        Call localVarCall = this.importSkusUsingCsvValidateBeforeCall(_file, null);
        Type localVarReturnType = new TypeToken<SkusImportCsvCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importSkusUsingCsvAsync(File _file, ApiCallback<SkusImportCsvCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.importSkusUsingCsvValidateBeforeCall(_file, _callback);
        Type localVarReturnType = new TypeToken<SkusImportCsvCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProductsCall(Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_date", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_date", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProductsValidateBeforeCall(Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        return this.listProductsCall(limit, page, order, startDate, endDate, _callback);
    }

    public ProductsListResponseBody listProducts(Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        ApiResponse<ProductsListResponseBody> localVarResp = this.listProductsWithHttpInfo(limit, page, order, startDate, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsListResponseBody> listProductsWithHttpInfo(Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        Call localVarCall = this.listProductsValidateBeforeCall(limit, page, order, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<ProductsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProductsAsync(Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback<ProductsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listProductsValidateBeforeCall(limit, page, order, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<ProductsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSkusInProductCall(String productId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productId}/skus".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_date", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_date", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSkusInProductValidateBeforeCall(String productId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling listSkusInProduct(Async)");
        }
        return this.listSkusInProductCall(productId, limit, page, order, startDate, endDate, _callback);
    }

    public ProductsSkusListResponseBody listSkusInProduct(String productId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        ApiResponse<ProductsSkusListResponseBody> localVarResp = this.listSkusInProductWithHttpInfo(productId, limit, page, order, startDate, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsSkusListResponseBody> listSkusInProductWithHttpInfo(String productId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        Call localVarCall = this.listSkusInProductValidateBeforeCall(productId, limit, page, order, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<ProductsSkusListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSkusInProductAsync(String productId, Integer limit, Integer page, ParameterOrder order, OffsetDateTime startDate, OffsetDateTime endDate, ApiCallback<ProductsSkusListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listSkusInProductValidateBeforeCall(productId, limit, page, order, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<ProductsSkusListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductCall(String productId, ProductsUpdateRequestBody productsUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductsUpdateRequestBody localVarPostBody = productsUpdateRequestBody;
        String localVarPath = "/v1/products/{productId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductValidateBeforeCall(String productId, ProductsUpdateRequestBody productsUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProduct(Async)");
        }
        return this.updateProductCall(productId, productsUpdateRequestBody, _callback);
    }

    public ProductsUpdateResponseBody updateProduct(String productId, ProductsUpdateRequestBody productsUpdateRequestBody) throws ApiException {
        ApiResponse<ProductsUpdateResponseBody> localVarResp = this.updateProductWithHttpInfo(productId, productsUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsUpdateResponseBody> updateProductWithHttpInfo(String productId, ProductsUpdateRequestBody productsUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(productId, productsUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductsUpdateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductAsync(String productId, ProductsUpdateRequestBody productsUpdateRequestBody, ApiCallback<ProductsUpdateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(productId, productsUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductsUpdateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductsInBulkCall(List<ProductsUpdateInBulkRequestBody> productsUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<ProductsUpdateInBulkRequestBody> localVarPostBody = productsUpdateInBulkRequestBody;
        String localVarPath = "/v1/products/bulk/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductsInBulkValidateBeforeCall(List<ProductsUpdateInBulkRequestBody> productsUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        return this.updateProductsInBulkCall(productsUpdateInBulkRequestBody, _callback);
    }

    public ProductsUpdateInBulkResponseBody updateProductsInBulk(List<ProductsUpdateInBulkRequestBody> productsUpdateInBulkRequestBody) throws ApiException {
        ApiResponse<ProductsUpdateInBulkResponseBody> localVarResp = this.updateProductsInBulkWithHttpInfo(productsUpdateInBulkRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsUpdateInBulkResponseBody> updateProductsInBulkWithHttpInfo(List<ProductsUpdateInBulkRequestBody> productsUpdateInBulkRequestBody) throws ApiException {
        Call localVarCall = this.updateProductsInBulkValidateBeforeCall(productsUpdateInBulkRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductsUpdateInBulkResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductsInBulkAsync(List<ProductsUpdateInBulkRequestBody> productsUpdateInBulkRequestBody, ApiCallback<ProductsUpdateInBulkResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateProductsInBulkValidateBeforeCall(productsUpdateInBulkRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductsUpdateInBulkResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductsMetadataInBulkCall(ProductsMetadataUpdateInBulkRequestBody productsMetadataUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductsMetadataUpdateInBulkRequestBody localVarPostBody = productsMetadataUpdateInBulkRequestBody;
        String localVarPath = "/v1/products/metadata/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductsMetadataInBulkValidateBeforeCall(ProductsMetadataUpdateInBulkRequestBody productsMetadataUpdateInBulkRequestBody, ApiCallback _callback) throws ApiException {
        return this.updateProductsMetadataInBulkCall(productsMetadataUpdateInBulkRequestBody, _callback);
    }

    public ProductsMetadataUpdateInBulkResponseBody updateProductsMetadataInBulk(ProductsMetadataUpdateInBulkRequestBody productsMetadataUpdateInBulkRequestBody) throws ApiException {
        ApiResponse<ProductsMetadataUpdateInBulkResponseBody> localVarResp = this.updateProductsMetadataInBulkWithHttpInfo(productsMetadataUpdateInBulkRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsMetadataUpdateInBulkResponseBody> updateProductsMetadataInBulkWithHttpInfo(ProductsMetadataUpdateInBulkRequestBody productsMetadataUpdateInBulkRequestBody) throws ApiException {
        Call localVarCall = this.updateProductsMetadataInBulkValidateBeforeCall(productsMetadataUpdateInBulkRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductsMetadataUpdateInBulkResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductsMetadataInBulkAsync(ProductsMetadataUpdateInBulkRequestBody productsMetadataUpdateInBulkRequestBody, ApiCallback<ProductsMetadataUpdateInBulkResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateProductsMetadataInBulkValidateBeforeCall(productsMetadataUpdateInBulkRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductsMetadataUpdateInBulkResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSkuCall(String productId, String skuId, ProductsSkusUpdateRequestBody productsSkusUpdateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductsSkusUpdateRequestBody localVarPostBody = productsSkusUpdateRequestBody;
        String localVarPath = "/v1/products/{productId}/skus/{skuId}".replace("{productId}", this.localVarApiClient.escapeString(productId.toString())).replace("{skuId}", this.localVarApiClient.escapeString(skuId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSkuValidateBeforeCall(String productId, String skuId, ProductsSkusUpdateRequestBody productsSkusUpdateRequestBody, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateSku(Async)");
        }
        if (skuId == null) {
            throw new ApiException("Missing the required parameter 'skuId' when calling updateSku(Async)");
        }
        return this.updateSkuCall(productId, skuId, productsSkusUpdateRequestBody, _callback);
    }

    public ProductsSkusUpdateResponseBody updateSku(String productId, String skuId, ProductsSkusUpdateRequestBody productsSkusUpdateRequestBody) throws ApiException {
        ApiResponse<ProductsSkusUpdateResponseBody> localVarResp = this.updateSkuWithHttpInfo(productId, skuId, productsSkusUpdateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ProductsSkusUpdateResponseBody> updateSkuWithHttpInfo(String productId, String skuId, ProductsSkusUpdateRequestBody productsSkusUpdateRequestBody) throws ApiException {
        Call localVarCall = this.updateSkuValidateBeforeCall(productId, skuId, productsSkusUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<ProductsSkusUpdateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSkuAsync(String productId, String skuId, ProductsSkusUpdateRequestBody productsSkusUpdateRequestBody, ApiCallback<ProductsSkusUpdateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.updateSkuValidateBeforeCall(productId, skuId, productsSkusUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ProductsSkusUpdateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

