/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.api;

import com.google.gson.reflect.TypeToken;
import io.voucherify.client.ApiCallback;
import io.voucherify.client.ApiClient;
import io.voucherify.client.ApiException;
import io.voucherify.client.ApiResponse;
import io.voucherify.client.Configuration;
import io.voucherify.client.Pair;
import io.voucherify.client.model.ParameterCreatedBeforeAfter;
import io.voucherify.client.model.ParameterFiltersListRedemptions;
import io.voucherify.client.model.ParameterOrderListRedemptions;
import io.voucherify.client.model.RedemptionsGetResponseBody;
import io.voucherify.client.model.RedemptionsListResponseBody;
import io.voucherify.client.model.RedemptionsRedeemRequestBody;
import io.voucherify.client.model.RedemptionsRedeemResponseBody;
import io.voucherify.client.model.RedemptionsRollbackCreateRequestBody;
import io.voucherify.client.model.RedemptionsRollbackCreateResponseBody;
import io.voucherify.client.model.RedemptionsRollbacksCreateRequestBody;
import io.voucherify.client.model.RedemptionsRollbacksCreateResponseBody;
import io.voucherify.client.model.VouchersRedemptionGetResponseBody;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RedemptionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RedemptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RedemptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getRedemptionCall(String redemptionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/redemptions/{redemptionId}".replace("{redemptionId}", this.localVarApiClient.escapeString(redemptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRedemptionValidateBeforeCall(String redemptionId, ApiCallback _callback) throws ApiException {
        if (redemptionId == null) {
            throw new ApiException("Missing the required parameter 'redemptionId' when calling getRedemption(Async)");
        }
        return this.getRedemptionCall(redemptionId, _callback);
    }

    public RedemptionsGetResponseBody getRedemption(String redemptionId) throws ApiException {
        ApiResponse<RedemptionsGetResponseBody> localVarResp = this.getRedemptionWithHttpInfo(redemptionId);
        return localVarResp.getData();
    }

    public ApiResponse<RedemptionsGetResponseBody> getRedemptionWithHttpInfo(String redemptionId) throws ApiException {
        Call localVarCall = this.getRedemptionValidateBeforeCall(redemptionId, null);
        Type localVarReturnType = new TypeToken<RedemptionsGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRedemptionAsync(String redemptionId, ApiCallback<RedemptionsGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getRedemptionValidateBeforeCall(redemptionId, _callback);
        Type localVarReturnType = new TypeToken<RedemptionsGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getVoucherRedemptionsCall(String code, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/vouchers/{code}/redemption".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getVoucherRedemptionsValidateBeforeCall(String code, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getVoucherRedemptions(Async)");
        }
        return this.getVoucherRedemptionsCall(code, _callback);
    }

    public VouchersRedemptionGetResponseBody getVoucherRedemptions(String code) throws ApiException {
        ApiResponse<VouchersRedemptionGetResponseBody> localVarResp = this.getVoucherRedemptionsWithHttpInfo(code);
        return localVarResp.getData();
    }

    public ApiResponse<VouchersRedemptionGetResponseBody> getVoucherRedemptionsWithHttpInfo(String code) throws ApiException {
        Call localVarCall = this.getVoucherRedemptionsValidateBeforeCall(code, null);
        Type localVarReturnType = new TypeToken<VouchersRedemptionGetResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getVoucherRedemptionsAsync(String code, ApiCallback<VouchersRedemptionGetResponseBody> _callback) throws ApiException {
        Call localVarCall = this.getVoucherRedemptionsValidateBeforeCall(code, _callback);
        Type localVarReturnType = new TypeToken<VouchersRedemptionGetResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRedemptionsCall(Integer limit, Integer page, String result, String campaign, String customer, ParameterOrderListRedemptions order, ParameterCreatedBeforeAfter createdAt, ParameterFiltersListRedemptions filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/redemptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (result != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("result", result));
        }
        if (campaign != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("campaign", campaign));
        }
        if (customer != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("customer", customer));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", (Object)order));
        }
        if (createdAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("created_at", createdAt));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRedemptionsValidateBeforeCall(Integer limit, Integer page, String result, String campaign, String customer, ParameterOrderListRedemptions order, ParameterCreatedBeforeAfter createdAt, ParameterFiltersListRedemptions filters, ApiCallback _callback) throws ApiException {
        return this.listRedemptionsCall(limit, page, result, campaign, customer, order, createdAt, filters, _callback);
    }

    public RedemptionsListResponseBody listRedemptions(Integer limit, Integer page, String result, String campaign, String customer, ParameterOrderListRedemptions order, ParameterCreatedBeforeAfter createdAt, ParameterFiltersListRedemptions filters) throws ApiException {
        ApiResponse<RedemptionsListResponseBody> localVarResp = this.listRedemptionsWithHttpInfo(limit, page, result, campaign, customer, order, createdAt, filters);
        return localVarResp.getData();
    }

    public ApiResponse<RedemptionsListResponseBody> listRedemptionsWithHttpInfo(Integer limit, Integer page, String result, String campaign, String customer, ParameterOrderListRedemptions order, ParameterCreatedBeforeAfter createdAt, ParameterFiltersListRedemptions filters) throws ApiException {
        Call localVarCall = this.listRedemptionsValidateBeforeCall(limit, page, result, campaign, customer, order, createdAt, filters, null);
        Type localVarReturnType = new TypeToken<RedemptionsListResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRedemptionsAsync(Integer limit, Integer page, String result, String campaign, String customer, ParameterOrderListRedemptions order, ParameterCreatedBeforeAfter createdAt, ParameterFiltersListRedemptions filters, ApiCallback<RedemptionsListResponseBody> _callback) throws ApiException {
        Call localVarCall = this.listRedemptionsValidateBeforeCall(limit, page, result, campaign, customer, order, createdAt, filters, _callback);
        Type localVarReturnType = new TypeToken<RedemptionsListResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call redeemStackedDiscountsCall(RedemptionsRedeemRequestBody redemptionsRedeemRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RedemptionsRedeemRequestBody localVarPostBody = redemptionsRedeemRequestBody;
        String localVarPath = "/v1/redemptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call redeemStackedDiscountsValidateBeforeCall(RedemptionsRedeemRequestBody redemptionsRedeemRequestBody, ApiCallback _callback) throws ApiException {
        return this.redeemStackedDiscountsCall(redemptionsRedeemRequestBody, _callback);
    }

    public RedemptionsRedeemResponseBody redeemStackedDiscounts(RedemptionsRedeemRequestBody redemptionsRedeemRequestBody) throws ApiException {
        ApiResponse<RedemptionsRedeemResponseBody> localVarResp = this.redeemStackedDiscountsWithHttpInfo(redemptionsRedeemRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<RedemptionsRedeemResponseBody> redeemStackedDiscountsWithHttpInfo(RedemptionsRedeemRequestBody redemptionsRedeemRequestBody) throws ApiException {
        Call localVarCall = this.redeemStackedDiscountsValidateBeforeCall(redemptionsRedeemRequestBody, null);
        Type localVarReturnType = new TypeToken<RedemptionsRedeemResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call redeemStackedDiscountsAsync(RedemptionsRedeemRequestBody redemptionsRedeemRequestBody, ApiCallback<RedemptionsRedeemResponseBody> _callback) throws ApiException {
        Call localVarCall = this.redeemStackedDiscountsValidateBeforeCall(redemptionsRedeemRequestBody, _callback);
        Type localVarReturnType = new TypeToken<RedemptionsRedeemResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call rollbackRedemptionCall(String redemptionId, String reason, String trackingId, RedemptionsRollbackCreateRequestBody redemptionsRollbackCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RedemptionsRollbackCreateRequestBody localVarPostBody = redemptionsRollbackCreateRequestBody;
        String localVarPath = "/v1/redemptions/{redemptionId}/rollback".replace("{redemptionId}", this.localVarApiClient.escapeString(redemptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (reason != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reason", reason));
        }
        if (trackingId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tracking_id", trackingId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rollbackRedemptionValidateBeforeCall(String redemptionId, String reason, String trackingId, RedemptionsRollbackCreateRequestBody redemptionsRollbackCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (redemptionId == null) {
            throw new ApiException("Missing the required parameter 'redemptionId' when calling rollbackRedemption(Async)");
        }
        return this.rollbackRedemptionCall(redemptionId, reason, trackingId, redemptionsRollbackCreateRequestBody, _callback);
    }

    public RedemptionsRollbackCreateResponseBody rollbackRedemption(String redemptionId, String reason, String trackingId, RedemptionsRollbackCreateRequestBody redemptionsRollbackCreateRequestBody) throws ApiException {
        ApiResponse<RedemptionsRollbackCreateResponseBody> localVarResp = this.rollbackRedemptionWithHttpInfo(redemptionId, reason, trackingId, redemptionsRollbackCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<RedemptionsRollbackCreateResponseBody> rollbackRedemptionWithHttpInfo(String redemptionId, String reason, String trackingId, RedemptionsRollbackCreateRequestBody redemptionsRollbackCreateRequestBody) throws ApiException {
        Call localVarCall = this.rollbackRedemptionValidateBeforeCall(redemptionId, reason, trackingId, redemptionsRollbackCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<RedemptionsRollbackCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rollbackRedemptionAsync(String redemptionId, String reason, String trackingId, RedemptionsRollbackCreateRequestBody redemptionsRollbackCreateRequestBody, ApiCallback<RedemptionsRollbackCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.rollbackRedemptionValidateBeforeCall(redemptionId, reason, trackingId, redemptionsRollbackCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<RedemptionsRollbackCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call rollbackStackedRedemptionsCall(String parentRedemptionId, String reason, String trackingId, RedemptionsRollbacksCreateRequestBody redemptionsRollbacksCreateRequestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RedemptionsRollbacksCreateRequestBody localVarPostBody = redemptionsRollbacksCreateRequestBody;
        String localVarPath = "/v1/redemptions/{parentRedemptionId}/rollbacks".replace("{parentRedemptionId}", this.localVarApiClient.escapeString(parentRedemptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (reason != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reason", reason));
        }
        if (trackingId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tracking_id", trackingId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"X-App-Id", "X-App-Token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rollbackStackedRedemptionsValidateBeforeCall(String parentRedemptionId, String reason, String trackingId, RedemptionsRollbacksCreateRequestBody redemptionsRollbacksCreateRequestBody, ApiCallback _callback) throws ApiException {
        if (parentRedemptionId == null) {
            throw new ApiException("Missing the required parameter 'parentRedemptionId' when calling rollbackStackedRedemptions(Async)");
        }
        return this.rollbackStackedRedemptionsCall(parentRedemptionId, reason, trackingId, redemptionsRollbacksCreateRequestBody, _callback);
    }

    public RedemptionsRollbacksCreateResponseBody rollbackStackedRedemptions(String parentRedemptionId, String reason, String trackingId, RedemptionsRollbacksCreateRequestBody redemptionsRollbacksCreateRequestBody) throws ApiException {
        ApiResponse<RedemptionsRollbacksCreateResponseBody> localVarResp = this.rollbackStackedRedemptionsWithHttpInfo(parentRedemptionId, reason, trackingId, redemptionsRollbacksCreateRequestBody);
        return localVarResp.getData();
    }

    public ApiResponse<RedemptionsRollbacksCreateResponseBody> rollbackStackedRedemptionsWithHttpInfo(String parentRedemptionId, String reason, String trackingId, RedemptionsRollbacksCreateRequestBody redemptionsRollbacksCreateRequestBody) throws ApiException {
        Call localVarCall = this.rollbackStackedRedemptionsValidateBeforeCall(parentRedemptionId, reason, trackingId, redemptionsRollbacksCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<RedemptionsRollbacksCreateResponseBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rollbackStackedRedemptionsAsync(String parentRedemptionId, String reason, String trackingId, RedemptionsRollbacksCreateRequestBody redemptionsRollbacksCreateRequestBody, ApiCallback<RedemptionsRollbacksCreateResponseBody> _callback) throws ApiException {
        Call localVarCall = this.rollbackStackedRedemptionsValidateBeforeCall(parentRedemptionId, reason, trackingId, redemptionsRollbacksCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<RedemptionsRollbacksCreateResponseBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

