/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.voucherify.client.JSON;
import io.voucherify.client.model.CustomerLoyaltyCampaignsEntry;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class CustomerLoyalty {
    public static final String SERIALIZED_NAME_POINTS = "points";
    @SerializedName(value="points")
    private Integer points;
    public static final String SERIALIZED_NAME_REFERRED_CUSTOMERS = "referred_customers";
    @SerializedName(value="referred_customers")
    private Integer referredCustomers;
    public static final String SERIALIZED_NAME_CAMPAIGNS = "campaigns";
    @SerializedName(value="campaigns")
    private Map<String, CustomerLoyaltyCampaignsEntry> campaigns;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CustomerLoyalty points(Integer points) {
        this.points = points;
        return this;
    }

    @Nullable
    public Integer getPoints() {
        return this.points;
    }

    public void setPoints(Integer points) {
        this.points = points;
    }

    public CustomerLoyalty referredCustomers(Integer referredCustomers) {
        this.referredCustomers = referredCustomers;
        return this;
    }

    @Nullable
    public Integer getReferredCustomers() {
        return this.referredCustomers;
    }

    public void setReferredCustomers(Integer referredCustomers) {
        this.referredCustomers = referredCustomers;
    }

    public CustomerLoyalty campaigns(Map<String, CustomerLoyaltyCampaignsEntry> campaigns) {
        this.campaigns = campaigns;
        return this;
    }

    public CustomerLoyalty putCampaignsItem(String key, CustomerLoyaltyCampaignsEntry campaignsItem) {
        if (this.campaigns == null) {
            this.campaigns = new HashMap<String, CustomerLoyaltyCampaignsEntry>();
        }
        this.campaigns.put(key, campaignsItem);
        return this;
    }

    @Nullable
    public Map<String, CustomerLoyaltyCampaignsEntry> getCampaigns() {
        return this.campaigns;
    }

    public void setCampaigns(Map<String, CustomerLoyaltyCampaignsEntry> campaigns) {
        this.campaigns = campaigns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerLoyalty customerLoyalty = (CustomerLoyalty)o;
        return Objects.equals(this.points, customerLoyalty.points) && Objects.equals(this.referredCustomers, customerLoyalty.referredCustomers) && Objects.equals(this.campaigns, customerLoyalty.campaigns);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.points, this.referredCustomers, this.campaigns);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerLoyalty {\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    referredCustomers: ").append(this.toIndentedString(this.referredCustomers)).append("\n");
        sb.append("    campaigns: ").append(this.toIndentedString(this.campaigns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CustomerLoyalty fromJson(String jsonString) throws IOException {
        return (CustomerLoyalty)JSON.getGson().fromJson(jsonString, CustomerLoyalty.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_POINTS);
        openapiFields.add(SERIALIZED_NAME_REFERRED_CUSTOMERS);
        openapiFields.add(SERIALIZED_NAME_CAMPAIGNS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CustomerLoyalty.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CustomerLoyalty.class));
            return new TypeAdapter<CustomerLoyalty>(){

                public void write(JsonWriter out, CustomerLoyalty value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CustomerLoyalty read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (CustomerLoyalty)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

