/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.customer.Customer;
import io.voucherify.client.model.loyalties.Reward;
import io.voucherify.client.model.order.Order;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class QualificationContext {
    @JsonProperty(value="tracking_id")
    private String trackingId;
    private Customer customer;
    private Order order;
    private Map<String, Object> metadata;
    private Reward reward;

    public static QualificationContextBuilder builder() {
        return new QualificationContextBuilder();
    }

    private QualificationContext() {
    }

    private QualificationContext(String trackingId, Customer customer, Order order, Map<String, Object> metadata, Reward reward) {
        this.trackingId = trackingId;
        this.customer = customer;
        this.order = order;
        this.metadata = metadata;
        this.reward = reward;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Order getOrder() {
        return this.order;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Reward getReward() {
        return this.reward;
    }

    public String toString() {
        return "QualificationContext(trackingId=" + this.getTrackingId() + ", customer=" + this.getCustomer() + ", order=" + this.getOrder() + ", metadata=" + this.getMetadata() + ", reward=" + this.getReward() + ")";
    }

    public static class QualificationContextBuilder {
        private String trackingId;
        private Customer customer;
        private Order order;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;
        private Reward reward;

        QualificationContextBuilder() {
        }

        @JsonProperty(value="tracking_id")
        public QualificationContextBuilder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public QualificationContextBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public QualificationContextBuilder order(Order order) {
            this.order = order;
            return this;
        }

        public QualificationContextBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public QualificationContextBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public QualificationContextBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public QualificationContextBuilder reward(Reward reward) {
            this.reward = reward;
            return this;
        }

        public QualificationContext build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new QualificationContext(this.trackingId, this.customer, this.order, metadata, this.reward);
        }

        public String toString() {
            return "QualificationContext.QualificationContextBuilder(trackingId=" + this.trackingId + ", customer=" + this.customer + ", order=" + this.order + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ", reward=" + this.reward + ")";
        }
    }
}

