/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.campaign;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.voucherify.client.json.serializer.CampaignImportVouchersSerializer;
import io.voucherify.client.model.campaign.CampaignImportVoucher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonSerialize(using=CampaignImportVouchersSerializer.class)
public class CampaignImportVouchers {
    private List<CampaignImportVoucher> vouchers;

    public static CampaignImportVouchersBuilder builder() {
        return new CampaignImportVouchersBuilder();
    }

    private CampaignImportVouchers() {
    }

    private CampaignImportVouchers(List<CampaignImportVoucher> vouchers) {
        this.vouchers = vouchers;
    }

    public List<CampaignImportVoucher> getVouchers() {
        return this.vouchers;
    }

    public String toString() {
        return "CampaignImportVouchers(vouchers=" + this.getVouchers() + ")";
    }

    public static class CampaignImportVouchersBuilder {
        private ArrayList<CampaignImportVoucher> vouchers;

        CampaignImportVouchersBuilder() {
        }

        public CampaignImportVouchersBuilder voucher(CampaignImportVoucher voucher) {
            if (this.vouchers == null) {
                this.vouchers = new ArrayList();
            }
            this.vouchers.add(voucher);
            return this;
        }

        public CampaignImportVouchersBuilder vouchers(Collection<? extends CampaignImportVoucher> vouchers) {
            if (this.vouchers == null) {
                this.vouchers = new ArrayList();
            }
            this.vouchers.addAll(vouchers);
            return this;
        }

        public CampaignImportVouchersBuilder clearVouchers() {
            if (this.vouchers != null) {
                this.vouchers.clear();
            }
            return this;
        }

        public CampaignImportVouchers build() {
            List<Object> vouchers;
            switch (this.vouchers == null ? 0 : this.vouchers.size()) {
                case 0: {
                    vouchers = Collections.emptyList();
                    break;
                }
                case 1: {
                    vouchers = Collections.singletonList(this.vouchers.get(0));
                    break;
                }
                default: {
                    vouchers = Collections.unmodifiableList(new ArrayList<CampaignImportVoucher>(this.vouchers));
                }
            }
            return new CampaignImportVouchers(vouchers);
        }

        public String toString() {
            return "CampaignImportVouchers.CampaignImportVouchersBuilder(vouchers=" + this.vouchers + ")";
        }
    }
}

