/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExportParams {
    private List<String> fields;
    private Map<String, Object> filters;

    public static ExportParamsBuilder builder() {
        return new ExportParamsBuilder();
    }

    private ExportParams() {
    }

    private ExportParams(List<String> fields, Map<String, Object> filters) {
        this.fields = fields;
        this.filters = filters;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public String toString() {
        return "ExportParams(fields=" + this.getFields() + ", filters=" + this.getFilters() + ")";
    }

    public static class ExportParamsBuilder {
        private ArrayList<String> fields;
        private ArrayList<String> filters$key;
        private ArrayList<Object> filters$value;

        ExportParamsBuilder() {
        }

        public ExportParamsBuilder field(String field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return this;
        }

        public ExportParamsBuilder fields(Collection<? extends String> fields) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return this;
        }

        public ExportParamsBuilder clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return this;
        }

        public ExportParamsBuilder filter(String filterKey, Object filterValue) {
            if (this.filters$key == null) {
                this.filters$key = new ArrayList();
                this.filters$value = new ArrayList();
            }
            this.filters$key.add(filterKey);
            this.filters$value.add(filterValue);
            return this;
        }

        public ExportParamsBuilder filters(Map<? extends String, ? extends Object> filters) {
            if (this.filters$key == null) {
                this.filters$key = new ArrayList();
                this.filters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filters.entrySet()) {
                this.filters$key.add($lombokEntry.getKey());
                this.filters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ExportParamsBuilder clearFilters() {
            if (this.filters$key != null) {
                this.filters$key.clear();
                this.filters$value.clear();
            }
            return this;
        }

        public ExportParams build() {
            Map<Object, Object> filters;
            List<Object> fields;
            switch (this.fields == null ? 0 : this.fields.size()) {
                case 0: {
                    fields = Collections.emptyList();
                    break;
                }
                case 1: {
                    fields = Collections.singletonList(this.fields.get(0));
                    break;
                }
                default: {
                    fields = Collections.unmodifiableList(new ArrayList<String>(this.fields));
                }
            }
            switch (this.filters$key == null ? 0 : this.filters$key.size()) {
                case 0: {
                    filters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    filters = Collections.singletonMap(this.filters$key.get(0), this.filters$value.get(0));
                    break;
                }
                default: {
                    filters = new LinkedHashMap(this.filters$key.size() < 0x40000000 ? 1 + this.filters$key.size() + (this.filters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.filters$key.size(); ++$i) {
                        filters.put(this.filters$key.get($i), this.filters$value.get($i));
                    }
                    filters = Collections.unmodifiableMap(filters);
                }
            }
            return new ExportParams(fields, filters);
        }

        public String toString() {
            return "ExportParams.ExportParamsBuilder(fields=" + this.fields + ", filters$key=" + this.filters$key + ", filters$value=" + this.filters$value + ")";
        }
    }
}

