/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.distribution;

import io.voucherify.client.model.customer.Customer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PublishVoucher {
    private String campaign;
    private String voucher;
    private Customer customer;
    private String channel;
    private Map<String, Object> metadata;

    public static PublishVoucherBuilder builder() {
        return new PublishVoucherBuilder();
    }

    private PublishVoucher() {
    }

    private PublishVoucher(String campaign, String voucher, Customer customer, String channel, Map<String, Object> metadata) {
        this.campaign = campaign;
        this.voucher = voucher;
        this.customer = customer;
        this.channel = channel;
        this.metadata = metadata;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public String getVoucher() {
        return this.voucher;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public String getChannel() {
        return this.channel;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "PublishVoucher(campaign=" + this.getCampaign() + ", voucher=" + this.getVoucher() + ", customer=" + this.getCustomer() + ", channel=" + this.getChannel() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class PublishVoucherBuilder {
        private String campaign;
        private String voucher;
        private Customer customer;
        private String channel;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        PublishVoucherBuilder() {
        }

        public PublishVoucherBuilder campaign(String campaign) {
            this.campaign = campaign;
            return this;
        }

        public PublishVoucherBuilder voucher(String voucher) {
            this.voucher = voucher;
            return this;
        }

        public PublishVoucherBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public PublishVoucherBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public PublishVoucherBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public PublishVoucherBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PublishVoucherBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public PublishVoucher build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new PublishVoucher(this.campaign, this.voucher, this.customer, this.channel, metadata);
        }

        public String toString() {
            return "PublishVoucher.PublishVoucherBuilder(campaign=" + this.campaign + ", voucher=" + this.voucher + ", customer=" + this.customer + ", channel=" + this.channel + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

