/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.order.OrderItem;
import io.voucherify.client.model.order.OrderStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Order {
    private String id;
    @JsonProperty(value="source_id")
    private String sourceId;
    @JsonProperty(value="result")
    private OrderStatus status;
    private Integer amount;
    private List<OrderItem> items;
    private Map<String, Object> metadata;

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    private Order() {
    }

    private Order(String id, String sourceId, OrderStatus status, Integer amount, List<OrderItem> items, Map<String, Object> metadata) {
        this.id = id;
        this.sourceId = sourceId;
        this.status = status;
        this.amount = amount;
        this.items = items;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Order(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", status=" + (Object)((Object)this.getStatus()) + ", amount=" + this.getAmount() + ", items=" + this.getItems() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class OrderBuilder {
        private String id;
        private String sourceId;
        private OrderStatus status;
        private Integer amount;
        private ArrayList<OrderItem> items;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        OrderBuilder() {
        }

        public OrderBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="source_id")
        public OrderBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @JsonProperty(value="result")
        public OrderBuilder status(OrderStatus status) {
            this.status = status;
            return this;
        }

        public OrderBuilder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public OrderBuilder item(OrderItem item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        public OrderBuilder items(Collection<? extends OrderItem> items) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        public OrderBuilder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        public OrderBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public OrderBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OrderBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public Order build() {
            Map<Object, Object> metadata;
            List<Object> items;
            switch (this.items == null ? 0 : this.items.size()) {
                case 0: {
                    items = Collections.emptyList();
                    break;
                }
                case 1: {
                    items = Collections.singletonList(this.items.get(0));
                    break;
                }
                default: {
                    items = Collections.unmodifiableList(new ArrayList<OrderItem>(this.items));
                }
            }
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Order(this.id, this.sourceId, this.status, this.amount, items, metadata);
        }

        public String toString() {
            return "Order.OrderBuilder(id=" + this.id + ", sourceId=" + this.sourceId + ", status=" + (Object)((Object)this.status) + ", amount=" + this.amount + ", items=" + this.items + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

