/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.promotion;

import io.voucherify.client.model.promotion.Tier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Promotion {
    private List<Tier> tiers;

    public static PromotionBuilder builder() {
        return new PromotionBuilder();
    }

    private Promotion() {
    }

    private Promotion(List<Tier> tiers) {
        this.tiers = tiers;
    }

    public List<Tier> getTiers() {
        return this.tiers;
    }

    public String toString() {
        return "Promotion(tiers=" + this.getTiers() + ")";
    }

    public static class PromotionBuilder {
        private ArrayList<Tier> tiers;

        PromotionBuilder() {
        }

        public PromotionBuilder tier(Tier tier) {
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.add(tier);
            return this;
        }

        public PromotionBuilder tiers(Collection<? extends Tier> tiers) {
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.addAll(tiers);
            return this;
        }

        public PromotionBuilder clearTiers() {
            if (this.tiers != null) {
                this.tiers.clear();
            }
            return this;
        }

        public Promotion build() {
            List<Object> tiers;
            switch (this.tiers == null ? 0 : this.tiers.size()) {
                case 0: {
                    tiers = Collections.emptyList();
                    break;
                }
                case 1: {
                    tiers = Collections.singletonList(this.tiers.get(0));
                    break;
                }
                default: {
                    tiers = Collections.unmodifiableList(new ArrayList<Tier>(this.tiers));
                }
            }
            return new Promotion(tiers);
        }

        public String toString() {
            return "Promotion.PromotionBuilder(tiers=" + this.tiers + ")";
        }
    }
}

