/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.validation;

import io.voucherify.client.model.customer.Customer;
import io.voucherify.client.model.order.Order;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PromotionValidation {
    private Customer customer;
    private Order order;
    private Map<String, Object> metadata;

    public static PromotionValidationBuilder builder() {
        return new PromotionValidationBuilder();
    }

    private PromotionValidation() {
    }

    private PromotionValidation(Customer customer, Order order, Map<String, Object> metadata) {
        this.customer = customer;
        this.order = order;
        this.metadata = metadata;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Order getOrder() {
        return this.order;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "PromotionValidation(customer=" + this.getCustomer() + ", order=" + this.getOrder() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class PromotionValidationBuilder {
        private Customer customer;
        private Order order;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        PromotionValidationBuilder() {
        }

        public PromotionValidationBuilder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public PromotionValidationBuilder order(Order order) {
            this.order = order;
            return this;
        }

        public PromotionValidationBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public PromotionValidationBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PromotionValidationBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public PromotionValidation build() {
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new PromotionValidation(this.customer, this.order, metadata);
        }

        public String toString() {
            return "PromotionValidation.PromotionValidationBuilder(customer=" + this.customer + ", order=" + this.order + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

