/*
 * Decompiled with CFR 0.152.
 */
package io.voucherify.client.model.voucher;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.voucherify.client.model.voucher.Discount;
import io.voucherify.client.model.voucher.Gift;
import io.voucherify.client.model.voucher.VoucherRedemption;
import io.voucherify.client.model.voucher.VoucherType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class Voucher {
    private String code;
    private String campaign;
    private String category;
    private VoucherType type;
    private Discount discount;
    private Gift gift;
    @JsonProperty(value="start_date")
    private Date startDate;
    @JsonProperty(value="expiration_date")
    private Date expirationDate;
    private VoucherRedemption redemption;
    private Boolean active;
    @JsonProperty(value="additional_info")
    private String additionalInfo;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> metadata;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> assets;
    @JsonProperty(value="is_referral_code")
    private Boolean isReferralCode;
    @JsonProperty(value="referrer_id")
    private String referrerId;
    @JsonProperty(value="updated_at")
    private Date updatedAt;

    public static VoucherBuilder builder() {
        return new VoucherBuilder();
    }

    private Voucher() {
    }

    private Voucher(String code, String campaign, String category, VoucherType type, Discount discount, Gift gift, Date startDate, Date expirationDate, VoucherRedemption redemption, Boolean active, String additionalInfo, Map<String, Object> metadata, Map<String, Object> assets, Boolean isReferralCode, String referrerId, Date updatedAt) {
        this.code = code;
        this.campaign = campaign;
        this.category = category;
        this.type = type;
        this.discount = discount;
        this.gift = gift;
        this.startDate = startDate;
        this.expirationDate = expirationDate;
        this.redemption = redemption;
        this.active = active;
        this.additionalInfo = additionalInfo;
        this.metadata = metadata;
        this.assets = assets;
        this.isReferralCode = isReferralCode;
        this.referrerId = referrerId;
        this.updatedAt = updatedAt;
    }

    public String getCode() {
        return this.code;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public String getCategory() {
        return this.category;
    }

    public VoucherType getType() {
        return this.type;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Gift getGift() {
        return this.gift;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public VoucherRedemption getRedemption() {
        return this.redemption;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getAssets() {
        return this.assets;
    }

    public Boolean getIsReferralCode() {
        return this.isReferralCode;
    }

    public String getReferrerId() {
        return this.referrerId;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        return "Voucher(code=" + this.getCode() + ", campaign=" + this.getCampaign() + ", category=" + this.getCategory() + ", type=" + (Object)((Object)this.getType()) + ", discount=" + this.getDiscount() + ", gift=" + this.getGift() + ", startDate=" + this.getStartDate() + ", expirationDate=" + this.getExpirationDate() + ", redemption=" + this.getRedemption() + ", active=" + this.getActive() + ", additionalInfo=" + this.getAdditionalInfo() + ", metadata=" + this.getMetadata() + ", assets=" + this.getAssets() + ", isReferralCode=" + this.getIsReferralCode() + ", referrerId=" + this.getReferrerId() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public static class VoucherBuilder {
        private String code;
        private String campaign;
        private String category;
        private VoucherType type;
        private Discount discount;
        private Gift gift;
        private Date startDate;
        private Date expirationDate;
        private VoucherRedemption redemption;
        private Boolean active;
        private String additionalInfo;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;
        private ArrayList<String> assets$key;
        private ArrayList<Object> assets$value;
        private Boolean isReferralCode;
        private String referrerId;
        private Date updatedAt;

        VoucherBuilder() {
        }

        public VoucherBuilder code(String code) {
            this.code = code;
            return this;
        }

        public VoucherBuilder campaign(String campaign) {
            this.campaign = campaign;
            return this;
        }

        public VoucherBuilder category(String category) {
            this.category = category;
            return this;
        }

        public VoucherBuilder type(VoucherType type) {
            this.type = type;
            return this;
        }

        public VoucherBuilder discount(Discount discount) {
            this.discount = discount;
            return this;
        }

        public VoucherBuilder gift(Gift gift) {
            this.gift = gift;
            return this;
        }

        @JsonProperty(value="start_date")
        public VoucherBuilder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="expiration_date")
        public VoucherBuilder expirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public VoucherBuilder redemption(VoucherRedemption redemption) {
            this.redemption = redemption;
            return this;
        }

        public VoucherBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        @JsonProperty(value="additional_info")
        public VoucherBuilder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public VoucherBuilder metadataEntry(String metadataEntryKey, Object metadataEntryValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataEntryKey);
            this.metadata$value.add(metadataEntryValue);
            return this;
        }

        public VoucherBuilder metadata(Map<? extends String, ? extends Object> metadata) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public VoucherBuilder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public VoucherBuilder asset(String assetKey, Object assetValue) {
            if (this.assets$key == null) {
                this.assets$key = new ArrayList();
                this.assets$value = new ArrayList();
            }
            this.assets$key.add(assetKey);
            this.assets$value.add(assetValue);
            return this;
        }

        public VoucherBuilder assets(Map<? extends String, ? extends Object> assets) {
            if (this.assets$key == null) {
                this.assets$key = new ArrayList();
                this.assets$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : assets.entrySet()) {
                this.assets$key.add($lombokEntry.getKey());
                this.assets$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public VoucherBuilder clearAssets() {
            if (this.assets$key != null) {
                this.assets$key.clear();
                this.assets$value.clear();
            }
            return this;
        }

        @JsonProperty(value="is_referral_code")
        public VoucherBuilder isReferralCode(Boolean isReferralCode) {
            this.isReferralCode = isReferralCode;
            return this;
        }

        @JsonProperty(value="referrer_id")
        public VoucherBuilder referrerId(String referrerId) {
            this.referrerId = referrerId;
            return this;
        }

        @JsonProperty(value="updated_at")
        public VoucherBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Voucher build() {
            Map<Object, Object> assets;
            Map<Object, Object> metadata;
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            switch (this.assets$key == null ? 0 : this.assets$key.size()) {
                case 0: {
                    assets = Collections.emptyMap();
                    break;
                }
                case 1: {
                    assets = Collections.singletonMap(this.assets$key.get(0), this.assets$value.get(0));
                    break;
                }
                default: {
                    assets = new LinkedHashMap(this.assets$key.size() < 0x40000000 ? 1 + this.assets$key.size() + (this.assets$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.assets$key.size(); ++$i) {
                        assets.put(this.assets$key.get($i), this.assets$value.get($i));
                    }
                    assets = Collections.unmodifiableMap(assets);
                }
            }
            return new Voucher(this.code, this.campaign, this.category, this.type, this.discount, this.gift, this.startDate, this.expirationDate, this.redemption, this.active, this.additionalInfo, metadata, assets, this.isReferralCode, this.referrerId, this.updatedAt);
        }

        public String toString() {
            return "Voucher.VoucherBuilder(code=" + this.code + ", campaign=" + this.campaign + ", category=" + this.category + ", type=" + (Object)((Object)this.type) + ", discount=" + this.discount + ", gift=" + this.gift + ", startDate=" + this.startDate + ", expirationDate=" + this.expirationDate + ", redemption=" + this.redemption + ", active=" + this.active + ", additionalInfo=" + this.additionalInfo + ", metadata$key=" + this.metadata$key + ", metadata$value=" + this.metadata$value + ", assets$key=" + this.assets$key + ", assets$value=" + this.assets$value + ", isReferralCode=" + this.isReferralCode + ", referrerId=" + this.referrerId + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

