/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.EditorConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.resourceTypes=/apps/wcm-io/caconfig/editor/components/page/editor", "sling.servlet.extensions=json", "sling.servlet.selectors=configNames", "sling.servlet.methods=GET"})
public class ConfigNamesServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configNames";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private ConfigurationResourceResolver configurationResourceResolver;
    @Reference
    private EditorConfig editorConfig;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            response.sendError(403);
            return;
        }
        Resource contextResource = request.getResource();
        try {
            JSONObject result = new JSONObject();
            result.putOpt("contextPath", (Object)this.getContextPath(contextResource));
            result.put(SELECTOR, (Object)this.getConfigNames(contextResource));
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(result.toString());
        }
        catch (JSONException ex) {
            throw new ServletException("Unable to generate JSON.", (Throwable)ex);
        }
    }

    private String getContextPath(Resource contextResource) {
        return this.configurationResourceResolver.getContextPath(contextResource);
    }

    private JSONArray getConfigNames(Resource contextResource) throws JSONException {
        JSONArray output = new JSONArray();
        SortedSet configNames = this.configManager.getConfigurationNames();
        for (String configName : configNames) {
            ConfigurationMetadata metadata = this.configManager.getConfigurationMetadata(configName);
            if (metadata == null) continue;
            JSONObject item = new JSONObject();
            item.put("configName", (Object)configName);
            item.putOpt("label", (Object)metadata.getLabel());
            item.putOpt("description", (Object)metadata.getDescription());
            item.put("collection", metadata.isCollection());
            item.put("exists", this.hasConfig(contextResource, configName, metadata.isCollection()));
            output.put((Object)item);
        }
        return output;
    }

    private boolean hasConfig(Resource contextResource, String configName, boolean collection) {
        if (collection) {
            Collection configs = this.configManager.getConfigurationCollection(contextResource, configName).getItems();
            return !configs.isEmpty();
        }
        ConfigurationData config = this.configManager.getConfiguration(contextResource, configName);
        return config != null && config.getResourcePath() != null;
    }
}

