/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.model;

import io.wcm.caconfig.editor.impl.EditorConfig;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={HttpServletRequest.class, Resource.class})
@ProviderType
public class EditorConfiguration {
    private final String configNamesUrl;
    private final String configDataUrl;
    private final String configPersistUrl;
    private final String contextPath;
    private final boolean enabled;

    @Inject
    public EditorConfiguration(@SlingObject Resource currentResource, @OSGiService ConfigurationResourceResolver configResourceResolver, @OSGiService EditorConfig editorConfig) {
        this.configNamesUrl = currentResource.getPath() + "." + "configNames" + ".json";
        this.configDataUrl = currentResource.getPath() + "." + "configData" + ".json";
        this.configPersistUrl = currentResource.getPath() + "." + "configPersist" + ".json";
        this.contextPath = configResourceResolver.getContextPath(currentResource);
        this.enabled = editorConfig.isEnabled();
    }

    public String getConfigNamesUrl() {
        return this.configNamesUrl;
    }

    public String getConfigDataUrl() {
        return this.configDataUrl;
    }

    public String getConfigPersistUrl() {
        return this.configPersistUrl;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

