angular.module('io.wcm.caconfig.templates', ['addCollectionItemModal.html', 'addConfigModal.html', 'deleteConfigModal.html', 'detailView.html', 'errorModal.html', 'multifield.html', 'overviewView.html', 'parameterValue.html', 'popupContainer.html', 'popupContent.html', 'saveConfigModal.html']);

angular.module("addCollectionItemModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("addCollectionItemModal.html",
    "<div class=\"coral-Modal\" id=\"caconfig-addCollectionItemModal\"\n" +
    "     ng-controller=\"AddCollectionItemController as addCollectionItem\">\n" +
    "  <div class=\"coral-Modal-header\">\n" +
    "    <i class=\"coral-Modal-typeIcon coral-Icon coral-Icon--sizeS\"></i>\n" +
    "    <h2 class=\"coral-Modal-title coral-Heading coral-Heading--2\">{{i18n.modal.addCollectionItem.title}}</h2>\n" +
    "    <button class=\"coral-MinimalButton coral-Modal-closeButton\"\n" +
    "            data-dismiss=\"modal\" type=\"button\" title=\"{{i18n.modal.close}}\">\n" +
    "      <i class=\"coral-Icon coral-Icon--sizeXS coral-Icon--close coral-MinimalButton-icon\"></i>\n" +
    "    </button>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-body\">\n" +
    "    <form class=\"coral-Form coral-Form--vertical\" name=\"addCollectionItemForm\" novalidate>\n" +
    "      <section class=\"coral-Form-fieldset\">\n" +
    "      <div class=\"coral-Form-fieldwrapper\">\n" +
    "          <label class=\"coral-Form-fieldlabel\">{{i18n.config.name}}</label>\n" +
    "          <i class=\"coral-Form-fielderror coral-Icon coral-Icon--alert\"\n" +
    "             data-init=\"quicktip\" data-quicktip-arrow=\"right\" data-quicktip-type=\"error\"\n" +
    "             data-quicktip-content=\"{{i18n.modal.tooltip.unique}}\"\n" +
    "             role=\"img\" tabindex=\"0\"\n" +
    "             ng-show=\"addCollectionItem.blacklist.indexOf(addCollectionItem.newCollectionName) !== -1\"></i>\n" +
    "          <i class=\"coral-Form-fielderror coral-Icon coral-Icon--alert\"\n" +
    "             data-init=\"quicktip\" data-quicktip-arrow=\"right\" data-quicktip-type=\"error\"\n" +
    "             data-quicktip-content=\"{{i18n.modal.tooltip.allowed}}\"\n" +
    "             role=\"img\" tabindex=\"0\"\n" +
    "             ng-show=\"addCollectionItemForm.collectionItemName.$error.pattern\"></i>\n" +
    "          <input class=\"coral-Form-field coral-Textfield {{addCollectionItem.blacklist.indexOf(addCollectionItem.newCollectionName) !== -1\n" +
    "                        ? 'ng-dirty ng-invalid' : ''}}\"\n" +
    "                 id=\"caconfig-collectionItemName\" name=\"collectionItemName\"\n" +
    "                 type=\"text\" placeholder=\"Item Name\"\n" +
    "                 ng-model=\"addCollectionItem.newCollectionName\" ng-pattern=\"addCollectionItem.itemTitleRegex\">\n" +
    "        </div>\n" +
    "      </section>\n" +
    "    </form>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-footer\">\n" +
    "    <button class=\"coral-Button coral-Button--primary\" data-dismiss=\"modal\" type=\"button\"\n" +
    "            ng-disabled=\"!addCollectionItemForm.$valid\n" +
    "                         || addCollectionItem.blacklist.indexOf(addCollectionItem.newCollectionName) !== -1\n" +
    "                         || !addCollectionItem.newCollectionName\"\n" +
    "            ng-click=\"addCollectionItem.addItem()\">\n" +
    "      {{i18n.button.ok}}\n" +
    "    </button>\n" +
    "    <button class=\"coral-Button coral-Button--secondary\" data-dismiss=\"modal\"\n" +
    "            type=\"button\">\n" +
    "      {{i18n.button.cancel}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "</div>");
}]);

angular.module("addConfigModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("addConfigModal.html",
    "<div class=\"coral-Modal\" id=\"caconfig-addConfigModal\"\n" +
    "     ng-controller=\"AddConfigController as addConfig\">\n" +
    "  <div class=\"coral-Modal-header\">\n" +
    "    <i class=\"coral-Modal-typeIcon coral-Icon coral-Icon--sizeS\"></i>\n" +
    "    <h2 class=\"coral-Modal-title coral-Heading coral-Heading--2\">{{i18n.modal.addConfig.title}}</h2>\n" +
    "    <button class=\"coral-MinimalButton coral-Modal-closeButton\" data-dismiss=\"modal\"\n" +
    "            type=\"button\" title=\"{{i18n.modal.close}}\">\n" +
    "      <i class=\"coral-Icon coral-Icon--sizeXS coral-Icon--close coral-MinimalButton-icon\"></i>\n" +
    "    </button>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-body caconfig-addConfigModal-body\">\n" +
    "    <form class=\"coral-Form coral-Form--aligned\" name=\"addConfigForm\">\n" +
    "      <section class=\"coral-Form-fieldset\">\n" +
    "        <label class=\"coral-Form-fieldlabel\">{{i18n.config.name}}</label>\n" +
    "        <span class=\"coral-Select\" id=\"caconfig-configurationSelect\">\n" +
    "          <button class=\"coral-Select-button coral-MinimalButton\" type=\"button\">\n" +
    "            <span class=\"coral-Select-button-text\">Choose</span>\n" +
    "          </button>\n" +
    "          <select class=\"coral-Select-select\">\n" +
    "            <option value=\"{{item.configName}}\"\n" +
    "                    ng-repeat=\"item in addConfig.getConfigNames() | filter:{exists:false}\">\n" +
    "              {{item.label || item.configName}}\n" +
    "            </option>\n" +
    "          </select>\n" +
    "        </span>\n" +
    "      </section>\n" +
    "    </form>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-footer\">\n" +
    "    <button class=\"coral-Button coral-Button--primary\" data-dismiss=\"modal\" type=\"button\"\n" +
    "            ng-click=\"addConfig.addConfig()\">\n" +
    "      {{i18n.button.ok}}\n" +
    "    </button>\n" +
    "    <button class=\"coral-Button coral-Button--secondary\" data-dismiss=\"modal\" type=\"button\">\n" +
    "      {{i18n.button.cancel}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "</div>");
}]);

angular.module("deleteConfigModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("deleteConfigModal.html",
    "<div class=\"coral-Modal\" id=\"caconfig-deleteConfigModal\"\n" +
    "     ng-controller=\"DeleteConfigController\">\n" +
    "  <div class=\"coral-Modal-header\">\n" +
    "    <i class=\"coral-Modal-typeIcon coral-Icon coral-Icon--sizeS\"></i>\n" +
    "    <h2 class=\"coral-Modal-title coral-Heading coral-Heading--2\">{{i18n.modal.deleteConfig.title}}</h2>\n" +
    "    <button class=\"coral-MinimalButton coral-Modal-closeButton\" data-dismiss=\"modal\"\n" +
    "            type=\"button\" title=\"{{i18n.modal.close}}\">\n" +
    "      <i class=\"coral-Icon coral-Icon--sizeXS coral-Icon--close coral-MinimalButton-icon\"></i>\n" +
    "    </button>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-body\">\n" +
    "    <p>{{i18n.modal.deleteConfig.message}}</p>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-footer\">\n" +
    "    <button class=\"coral-Button coral-Button--warning\" data-dismiss=\"modal\" type=\"button\"\n" +
    "            ng-click=\"deleteConfig()\">\n" +
    "      {{i18n.button.ok}}\n" +
    "    </button>\n" +
    "    <button class=\"coral-Button coral-Button--secondary\" data-dismiss=\"modal\" type=\"button\">\n" +
    "      {{i18n.button.cancel}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "</div>");
}]);

angular.module("detailView.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("detailView.html",
    "<form class=\"caconfig-detail\" name=\"configForm\" novalidate ng-cloak>\n" +
    "  <button class=\"coral-Button coral-Button--square coral-Button--default\"\n" +
    "          title=\"{{i18n.button.home}}\"\n" +
    "          ng-click=\"detail.isModified(configForm.$pristine) ? saveWarning() : go()\">\n" +
    "    <i class=\"coral-Icon coral-Icon--home\"></i>\n" +
    "  </button>\n" +
    "  <button class=\"coral-Button coral-Button--primary\"\n" +
    "          ng-disabled=\"configForm.$invalid || !detail.isModified(configForm.$pristine)\"\n" +
    "          ng-click=\"detail.saveConfig()\">\n" +
    "    {{i18n.button.save}}\n" +
    "  </button>\n" +
    "  <button class=\"coral-Button coral-Button--secondary\"\n" +
    "          ng-click=\"go(detail.current.parent ? detail.current.parent.configName : '')\">\n" +
    "    {{i18n.button.cancel}}\n" +
    "  </button>\n" +
    "  <button class=\"coral-Button coral-Button--square coral-Button--default\"\n" +
    "          title=\"{{detail.current.isCollection ? i18n.button.deleteCollection : i18n.button.deleteConfig}}\"\n" +
    "          ng-show=\"detail.current.configs.length\"\n" +
    "          ng-click=\"detail.removeConfig()\">\n" +
    "    <i class=\"coral-Icon coral-Icon--delete\"></i>\n" +
    "  </button>\n" +
    "\n" +
    "  <p>{{i18n.contextPath}}: <code>{{detail.current.contextPath}}</code></p>\n" +
    "\n" +
    "  <h2>\n" +
    "    <span class=\"caconfig-breadcrumb\" ng-repeat=\"breadcrumb in detail.current.breadcrumbs\">\n" +
    "      <span class=\"coral-Link caconfig-breadcrumb-link\"\n" +
    "            ng-click=\"detail.isModified(configForm.$pristine)\n" +
    "              ? saveWarning(breadcrumb.configName) : go(breadcrumb.configName)\">\n" +
    "        {{breadcrumb.label}}\n" +
    "      </span> /\n" +
    "      <span ng-show=\"breadcrumb.itemName\">{{breadcrumb.itemName}} / </span>\n" +
    "    </span>\n" +
    "    {{detail.current.label}}\n" +
    "  </h2>\n" +
    "  <p>{{detail.current.description}}</p>\n" +
    "\n" +
    "  <p class=\"caconfig-collectionInheritance coral-Well\"\n" +
    "       ng-show=\"detail.current.isCollection\">\n" +
    "    <label class=\"coral-Checkbox\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-model=\"detail.current.collectionProperties['sling:configCollectionInherit']\">\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "      <span class=\"coral-Checkbox-description\">{{i18n.config.inheritance.collection}}</span>\n" +
    "    </label>\n" +
    "  </p>\n" +
    "\n" +
    "  <div class=\"caconfig-configurationDetails\" ng-repeat=\"config in detail.current.configs\" ng-cloak>\n" +
    "    <table class=\"coral-Table coral-Table--hover\" ng-cloak>\n" +
    "      <thead>\n" +
    "      <tr class=\"coral-Table-row\">\n" +
    "        <th class=\"coral-Table-headerCell\"  style=\"width: 15%;\">\n" +
    "          <h3 ng-show=\"detail.current.isCollection\">{{config.collectionItemName}}</h3>\n" +
    "        </th>\n" +
    "        <th class=\"coral-Table-headerCell\">\n" +
    "          <label class=\"caconfig-propertyInheritance coral-Checkbox\">\n" +
    "            <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "                   ng-model=\"detail.getConfigPropertyInherit(config).value\"\n" +
    "                   ng-change=\"detail.handleConfigPropertyInheritChange(config)\" />\n" +
    "            <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "            <span class=\"coral-Checkbox-description\">{{i18n.config.inheritance.property}}</span>\n" +
    "          </label>\n" +
    "        </th>\n" +
    "        <th class=\"coral-Table-headerCell\" style=\"width: 1%;\"></th>\n" +
    "        <th class=\"coral-Table-headerCell\" style=\"width: 1%;\"></th>\n" +
    "        <th class=\"coral-Table-headerCell\" style=\"width: 1%;\">\n" +
    "          <i class=\"coral-Icon coral-Icon--delete caconfig-delete-item\" title=\"{{i18n.button.deleteItem}}\"\n" +
    "             ng-show=\"detail.current.isCollection\"\n" +
    "             ng-click=\"detail.removeCollectionItem($index)\"></i>\n" +
    "        </th>\n" +
    "      </tr>\n" +
    "      <tr class=\"coral-Table-row\">\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.property}}</th>\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.value}}</th>\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.description}}</th>\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.inherited}}</th>\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.overridden}}</th>\n" +
    "      </tr>\n" +
    "      </thead>\n" +
    "      <tbody>\n" +
    "      <tr class=\"coral-Table-row\"\n" +
    "          ng-repeat=\"property in config.properties\"\n" +
    "          ng-hide=\"property.name==='sling:configPropertyInherit'\" ng-cloak>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          {{property.metadata.label || property.name}}\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\" caconfig-parameter-value=\"property\" caconfig-is-new-item=\"config.isNewItem\">\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          <caconfig-description-popup ng-show=\"property.metadata.description\">\n" +
    "            <caconfig-popup-content>\n" +
    "              {{property.metadata.description}}\n" +
    "            </caconfig-popup-content>\n" +
    "          </caconfig-description-popup>\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          <label class=\"coral-Checkbox\">\n" +
    "            <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "              ng-model=\"property.inherited\"\n" +
    "              ng-disabled=\"!detail.getConfigPropertyInherit(config).value\n" +
    "                           || property.overridden || property.nestedConfig\n" +
    "                           || property.nestedConfigCollection\"\n" +
    "              ng-change=\"detail.handleInheritedChange(property)\">\n" +
    "            <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "          </label>\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          <label class=\"coral-Checkbox\">\n" +
    "            <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "              ng-model=\"property.overridden\" ng-disabled=\"true\" ng-readonly=\"true\">\n" +
    "            <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "          </label>\n" +
    "        </td>\n" +
    "      </tr>\n" +
    "      </tbody>\n" +
    "    </table>\n" +
    "  </div>\n" +
    "\n" +
    "  <p><button ng-show=\"detail.current.isCollection\" ng-click=\"detail.addCollectionItem()\" class=\"coral-Button coral-Button--primary\">{{i18n.button.addItem}}</button></p>\n" +
    "\n" +
    "</form>");
}]);

angular.module("errorModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("errorModal.html",
    "<div class=\"coral-Modal\" id=\"caconfig-errorModal\"\n" +
    "     ng-controller=\"ErrorController as errorModal\">\n" +
    "  <div class=\"coral-Modal-header\">\n" +
    "    <i class=\"coral-Modal-typeIcon coral-Icon coral-Icon--sizeS\"></i>\n" +
    "    <h2 class=\"coral-Modal-title coral-Heading coral-Heading--2\">{{i18n.title}}</h2>\n" +
    "    <button class=\"coral-MinimalButton coral-Modal-closeButton\" data-dismiss=\"modal\"\n" +
    "            type=\"button\" title=\"{{i18n.modal.close}}\">\n" +
    "      <i class=\"coral-Icon coral-Icon--sizeXS coral-Icon--close coral-MinimalButton-icon\"></i>\n" +
    "    </button>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-body\">\n" +
    "    <p>{{errorModal.message}}</p>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-footer\">\n" +
    "    <button class=\"coral-Button\" data-dismiss=\"modal\" type=\"button\">\n" +
    "      {{i18n.modal.close}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "</div>");
}]);

angular.module("multifield.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("multifield.html",
    "<div>\n" +
    " <div class=\"caconfig-multifield caconfig-multifield--empty\"\n" +
    "      ng-hide=\"parameter.overridden || parameter.inherited || values.length\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           ng-show=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-disabled=\"true\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input class=\"coral-Textfield\" type=\"type\"\n" +
    "           ng-hide=\"type==='checkbox'\"\n" +
    "           ng-disabled=\"true\" />\n" +
    "    <div class=\"coral-ButtonGroup\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral-Button coral-Button--secondary\"\n" +
    "              ng-click=\"addNewValue(0)\">\n" +
    "        <i class=\"coral-Icon coral-Icon--add\"></i>\n" +
    "      </button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral-Button coral-Button--secondary caconfig-disabled-button\"\n" +
    "              ng-disabled=\"true\">\n" +
    "        <i class=\"coral-Icon coral-Icon--minus\"></i>\n" +
    "      </button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "  <div class=\"caconfig-multifield\"\n" +
    "       ng-show=\"parameter.overridden || parameter.inherited\" ng-repeat=\"effectiveValue in effectiveValues\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           ng-show=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-disabled=\"true\"\n" +
    "             ng-readonly=\"true\"\n" +
    "             ng-model=\"effectiveValue.value\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input class=\"coral-Textfield\" type=\"type\"\n" +
    "           ng-hide=\"type==='checkbox'\"\n" +
    "           ng-disabled=\"true\"\n" +
    "           ng-readonly=\"true\"\n" +
    "           ng-model=\"effectiveValue.value\" />\n" +
    "    <div class=\"coral-ButtonGroup\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral-Button coral-Button--secondary caconfig-disabled-button\"\n" +
    "              ng-disabled=\"true\">\n" +
    "        <i class=\"coral-Icon coral-Icon--add\"></i>\n" +
    "      </button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral-Button coral-Button--secondary caconfig-disabled-button\"\n" +
    "              ng-disabled=\"true\">\n" +
    "        <i class=\"coral-Icon coral-Icon--minus\"></i>\n" +
    "      </button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "  <div class=\"caconfig-multifield\"\n" +
    "       ng-hide=\"parameter.overridden || parameter.inherited\" ng-repeat=\"value in values\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           ng-show=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-model=\"value.value\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input class=\"coral-Textfield\" type=\"type\"\n" +
    "           ng-hide=\"type==='checkbox'\"\n" +
    "           ng-model=\"value.value\"\n" +
    "           ng-pattern=\"pattern\" />\n" +
    "    <div class=\"coral-ButtonGroup\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral-Button coral-Button--secondary\"\n" +
    "              ng-click=\"addNewValue($index)\">\n" +
    "        <i class=\"coral-Icon coral-Icon--add\"></i>\n" +
    "      </button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral-Button coral-Button--secondary\"\n" +
    "              ng-click=\"removeValue($index)\">\n" +
    "        <i class=\"coral-Icon coral-Icon--minus\"></i>\n" +
    "      </button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n" +
    "");
}]);

angular.module("overviewView.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("overviewView.html",
    "<div class=\"caconfig-overview\" ng-cloak>\n" +
    "  <button class=\"coral-Button coral-Button--primary\"\n" +
    "          ng-disabled=\"!overview.hasNonExistingConfig()\"\n" +
    "          ng-click=\"overview.showNonExistingConfigs()\">\n" +
    "    {{i18n.button.add}}\n" +
    "  </button>\n" +
    "\n" +
    "  <p class=\"caconfig-contextPath\">{{i18n.contextPath}}: <code>{{overview.state.contextPath}}</code></p>\n" +
    "\n" +
    "  <table class=\"coral-Table coral-Table--hover\"\n" +
    "         ng-show=\"(overview.state.configNames | filter:{exists:true}).length\" ng-cloak>\n" +
    "    <thead>\n" +
    "      <tr class=\"coral-Table-row\">\n" +
    "        <th class=\"coral-Table-headerCell\" style=\"width:1%\"></th>\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.name}}</th>\n" +
    "        <th class=\"coral-Table-headerCell\">{{i18n.config.description}}</th>\n" +
    "      </tr>\n" +
    "    </thead>\n" +
    "    <tbody>\n" +
    "      <tr class=\"coral-Table-row\"\n" +
    "          ng-repeat=\"config in overview.state.configNames | filter:{exists:true}\"\n" +
    "          ng-click=\"go(config.configName)\" ng-cloak>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          <i class=\"coral-Icon coral-Icon--sizeS\"\n" +
    "             ng-class=\"{'coral-Icon--page': !config.collection,\n" +
    "                        'coral-Icon--pages': config.collection}\"></i>\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          {{config.label || config.configName}}\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          {{config.description}}\n" +
    "        </td>\n" +
    "      </tr>\n" +
    "    </tbody>\n" +
    "  </table>\n" +
    "</div>");
}]);

angular.module("parameterValue.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("parameterValue.html",
    "<div ng-switch on=\"type\">\n" +
    "\n" +
    "  <div ng-switch-when=\"text\">\n" +
    "    <input class=\"coral-Textfield\" type=\"text\"\n" +
    "           ng-hide=\"parameter.overridden || parameter.inherited\"\n" +
    "           ng-model=\"parameter.value\" />\n" +
    "    <input class=\"coral-Textfield\" type=\"text\"\n" +
    "           ng-show=\"parameter.overridden || parameter.inherited\"\n" +
    "           ng-model=\"parameter.effectiveValue\"\n" +
    "           ng-disabled=\"true\" ng-readonly=\"true\" />\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-switch-when=\"number\">\n" +
    "    <input class=\"coral-Textfield\" type=\"text\"\n" +
    "           ng-hide=\"parameter.overridden || parameter.inherited\"\n" +
    "           ng-model=\"parameter.value\"\n" +
    "           ng-pattern=\"pattern\" />\n" +
    "    <input class=\"coral-Textfield\" type=\"text\"\n" +
    "           ng-show=\"parameter.overridden || parameter.inherited\"\n" +
    "           ng-model=\"parameter.effectiveValue\"\n" +
    "           ng-disabled=\"true\" ng-readonly=\"true\" />\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-switch-when=\"checkbox\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           ng-hide=\"parameter.overridden || parameter.inherited\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-model=\"parameter.value\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           ng-show=\"parameter.overridden || parameter.inherited\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-model=\"parameter.effectiveValue\"\n" +
    "             ng-disabled=\"true\" ng-readonly=\"true\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-switch-when=\"multivalue\">\n" +
    "    <caconfig-multifield parameter=\"parameter\" />\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-switch-when=\"nestedConfig\">\n" +
    "    <button class=\"coral-Button coral-Button--block coral-Button--default\"\n" +
    "            ng-disabled=\"isNewItem\"\n" +
    "            ng-click=\"form.$pristine ? go(parameter.nestedConfig.configName)\n" +
    "                      : saveWarning(parameter.nestedConfig.configName)\">\n" +
    "      {{i18n.button.edit}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-switch-when=\"nestedConfigCollection\">\n" +
    "    <button class=\"coral-Button coral-Button--block coral-Button--default\"\n" +
    "            ng-disabled=\"isNewItem\"\n" +
    "            ng-click=\"form.$pristine ? go(parameter.nestedConfigCollection.configName)\n" +
    "                      : saveWarning(parameter.nestedConfigCollection.configName)\">\n" +
    "      {{i18n.button.edit}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-switch-default>\n" +
    "    <span>{{parameter.value}}</span>\n" +
    "  </div>\n" +
    "\n" +
    "</div>\n" +
    "");
}]);

angular.module("popupContainer.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("popupContainer.html",
    "<div>\n" +
    "  <button class=\"coral-MinimalButton\" data-target=\"#{{id}}\" data-toggle=\"popover\">\n" +
    "    <i class=\"coral-Icon coral-Icon--infoCircle coral-Icon--sizeM coral-MinimalButton-icon\"></i>\n" +
    "  </button>\n" +
    "  <div class=\"coral-Popover\"  id=\"{{id}}\" ng-transclude>\n" +
    "  </div>\n" +
    "</div>\n" +
    "");
}]);

angular.module("popupContent.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("popupContent.html",
    "<div class=\"coral-Popover-content u-coral-padding\" ng-transclude>\n" +
    "</div>\n" +
    "");
}]);

angular.module("saveConfigModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("saveConfigModal.html",
    "<div class=\"coral-Modal\"\n" +
    "     id=\"caconfig-saveConfigModal\"\n" +
    "     ng-controller=\"SaveConfigController as saveConfig\">\n" +
    "  <div class=\"coral-Modal-header\">\n" +
    "    <i class=\"coral-Modal-typeIcon coral-Icon coral-Icon--sizeS\"></i>\n" +
    "    <h2 class=\"coral-Modal-title coral-Heading coral-Heading--2\">{{i18n.modal.saveConfig.title}}</h2>\n" +
    "    <button class=\"coral-MinimalButton coral-Modal-closeButton\" data-dismiss=\"modal\"\n" +
    "            type=\"button\" title=\"{{i18n.modal.close}}\">\n" +
    "      <i class=\"coral-Icon coral-Icon--sizeXS coral-Icon--close coral-MinimalButton-icon\"></i>\n" +
    "    </button>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-body\">\n" +
    "    <p>{{i18n.modal.saveConfig.message}}</p>\n" +
    "  </div>\n" +
    "  <div class=\"coral-Modal-footer\">\n" +
    "    <button class=\"coral-Button coral-Button--primary\" data-dismiss=\"modal\"\n" +
    "            type=\"button\"\n" +
    "            ng-click=\"saveConfig.saveConfigWithRedirect()\">\n" +
    "      {{i18n.button.save}}\n" +
    "    </button>\n" +
    "    <button class=\"coral-Button coral-Button--secondary\"  data-dismiss=\"modal\"\n" +
    "            type=\"button\"\n" +
    "            ng-click=\"goToRedirectUrl()\">\n" +
    "      {{i18n.button.discard}}\n" +
    "    </button>\n" +
    "    <button class=\"coral-Button coral-Button--secondary\" data-dismiss=\"modal\"\n" +
    "            type=\"button\">\n" +
    "      {{i18n.button.cancel}}\n" +
    "    </button>\n" +
    "  </div>\n" +
    "</div>");
}]);
