/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockAemAdapterFactoryTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Before
    public void setUp() {
        ContentLoader contentLoader = this.context.load();
        contentLoader.json("/json-import-samples/application.json", "/apps/sample");
        contentLoader.json("/json-import-samples/content.json", "/content/sample/en");
    }

    @Test
    public void testPageManager() {
        PageManager pageManager = this.context.pageManager();
        Assert.assertNotNull((Object)pageManager);
        Page page = pageManager.getPage("/content/sample/en");
        Assert.assertNotNull((Object)page);
    }

    public void testPage() {
        Resource sample = this.context.resourceResolver().getResource("/content/sample");
        Assert.assertNull((Object)sample.adaptTo(Page.class));
        Resource en = this.context.resourceResolver().getResource("/content/sample/en");
        Assert.assertNotNull((Object)en.adaptTo(Page.class));
        Resource enContent = this.context.resourceResolver().getResource("/content/sample/en/jcr:content");
        Assert.assertNull((Object)enContent.adaptTo(Page.class));
    }

    @Test
    public void testTemplate() {
        Resource homepage = this.context.resourceResolver().getResource("/apps/sample/templates/homepage");
        Assert.assertNotNull((Object)homepage.adaptTo(Template.class));
        Resource component = this.context.resourceResolver().getResource("/apps/sample/components/title");
        Assert.assertNull((Object)component.adaptTo(Template.class));
    }
}

