/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MockAssetManagerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Test
    public void testCreateAsset() throws IOException {
        InputStream testImage = this.openTestAsset();
        String assetName = "myasset.gif";
        String mimeType = "image/gif";
        Asset asset = this.context.assetManager().createAsset(this.context.uniqueRoot().dam() + '/' + assetName, testImage, "image/gif", true);
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getOriginal().getStream());
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)this.openTestAsset(), (InputStream)asset.getOriginal().getStream()));
        Assert.assertEquals((Object)asset.getName(), (Object)assetName);
        Assert.assertEquals((Object)asset.getMimeType(), (Object)mimeType);
    }

    private InputStream openTestAsset() {
        return this.getClass().getClassLoader().getResourceAsStream("sample-image.gif");
    }
}

