/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.google.common.collect.ImmutableMap;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockComponentManagerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private ComponentManager underTest;

    @Before
    public void setUp() {
        this.context.create().resource("/apps/app1/components/c1", (Map)ImmutableMap.builder().put((Object)"jcr:title", (Object)"myTitle").put((Object)"jcr:description", (Object)"myDescription").put((Object)"componentGroup", (Object)"myGroup").put((Object)"cq:noDecoration", (Object)true).build());
        this.context.create().resource("/apps/app1/components/c1/cq:htmlTag", (Map)ImmutableMap.builder().put((Object)"cq:tagName", (Object)"myTag").put((Object)"prop2", (Object)"myValue2").build());
        this.context.create().resource("/libs/app1/components/c2");
        this.context.create().resource("/apps/app1/components/c2");
        this.context.create().resource("/libs/app1/components/c3");
        this.context.create().resource("/apps/app1/components/c4", new Object[]{"sling:resourceSuperType", "app1/components/c1"});
        this.context.create().resource("/content/myresource", (Map)ImmutableMap.builder().put((Object)"sling:resourceType", (Object)"/apps/app1/components/c1").build());
        this.underTest = (ComponentManager)this.context.resourceResolver().adaptTo(ComponentManager.class);
    }

    @Test
    public void testGetComponent() {
        Component component = this.underTest.getComponent("/apps/app1/components/c1");
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)component.getPath());
        Assert.assertEquals((Object)"c1", (Object)component.getName());
        Assert.assertEquals((Object)"myTitle", (Object)component.getTitle());
        Assert.assertEquals((Object)"myDescription", (Object)component.getDescription());
        Assert.assertEquals((Object)"myTitle", (Object)component.getProperties().get("jcr:title", String.class));
        Assert.assertTrue((StringUtils.isEmpty((CharSequence)component.getResourceType()) || StringUtils.equals((CharSequence)"nt:unstructured", (CharSequence)component.getResourceType()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)component.isAccessible());
        Assert.assertNotNull((Object)component.adaptTo(Resource.class));
        Assert.assertEquals((Object)"myGroup", (Object)component.getComponentGroup());
        Assert.assertTrue((boolean)component.noDecoration());
        Assert.assertEquals((Object)"myTag", component.getHtmlTagAttributes().get("cq:tagName"));
        Assert.assertEquals((Object)"myValue2", component.getHtmlTagAttributes().get("prop2"));
        Assert.assertNull((Object)component.getSuperComponent());
    }

    @Test
    public void testSuperComponent() {
        Component component = this.underTest.getComponent("/apps/app1/components/c4");
        Component superComponent = component.getSuperComponent();
        Assert.assertNotNull((Object)superComponent);
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)superComponent.getPath());
    }

    @Test
    public void testInvalidComponent() {
        Component component = this.underTest.getComponent("/invalidPath");
        Assert.assertNull((Object)component);
    }

    @Test
    public void testGetComponentWithSearchPath() {
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)this.underTest.getComponent("app1/components/c1").getPath());
        Assert.assertEquals((Object)"/apps/app1/components/c2", (Object)this.underTest.getComponent("app1/components/c2").getPath());
        Assert.assertEquals((Object)"/libs/app1/components/c3", (Object)this.underTest.getComponent("app1/components/c3").getPath());
    }

    @Test
    public void testGetComponentOfResource() {
        Resource resource = this.context.resourceResolver().getResource("/content/myresource");
        Component component = this.underTest.getComponentOfResource(resource);
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)component.getPath());
    }

    @Test
    public void testGetComponentOfResourceWithoutResourceType() {
        this.context.create().resource("/content/myresourceWithoutResourceType", (Map)ImmutableMap.builder().build());
        Resource resource = this.context.resourceResolver().getResource("/content/myresourceWithoutResourceType");
        Component component = this.underTest.getComponentOfResource(resource);
        Assert.assertNull((Object)component);
    }
}

