/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.collect.ImmutableMap;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockEditContextTest {
    private static final String COMPONENT_RESOURCE_TYPE = "/apps/test/components/component1";
    private static final String PAGE_PATH = "/content/page1";
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Page page;
    private Resource resource;
    private ComponentContext componentContext;
    private EditContext underTest;

    @Before
    public void setUp() {
        WCMMode.EDIT.toRequest((ServletRequest)this.context.request());
        this.context.create().resource(COMPONENT_RESOURCE_TYPE, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"cq:Component").build());
        this.page = this.context.create().page(PAGE_PATH);
        this.resource = this.context.create().resource(this.page.getContentResource().getPath() + "/comp1", (Map)ImmutableMap.builder().put((Object)"sling:resourceType", (Object)COMPONENT_RESOURCE_TYPE).build());
        this.context.currentPage(this.page);
        this.context.currentResource(this.resource);
        this.componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        this.underTest = this.componentContext.getEditContext();
        Assert.assertNotNull((Object)this.underTest);
    }

    @Test
    public void testGetComponentContext() {
        Assert.assertSame((Object)this.componentContext, (Object)this.underTest.getComponentContext());
    }

    @Test
    public void testGetComponent() {
        Component component = this.underTest.getComponent();
        Assert.assertEquals((Object)COMPONENT_RESOURCE_TYPE, (Object)component.getPath());
    }

    @Test
    public void testAttributes() {
        this.underTest.setAttribute("attr1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.underTest.getAttribute("attr1"));
    }

    @Test
    public void testGetEditConfig() {
        EditConfig editConfig = this.underTest.getEditConfig();
        Assert.assertNotNull((Object)editConfig);
    }
}

