/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Calendar;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MockPageManagerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private PageManager pageManager;
    private ResourceResolver resourceResolver;

    @Before
    public void setUp() throws Exception {
        this.resourceResolver = (ResourceResolver)Mockito.spy((Object)this.context.resourceResolver());
        this.context.load().json("/json-import-samples/content.json", "/content/sample/en");
        this.pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
    }

    @Test
    public void testGetPage() {
        Page page = this.pageManager.getPage("/content/sample/en");
        Assert.assertNotNull((Object)page);
    }

    @Test
    public void testCreatePage() throws WCMException, PersistenceException {
        this.testCreatePageInternal(false);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.never())).commit();
    }

    @Test
    public void testCreatePageWithAutoSave() throws WCMException, PersistenceException {
        this.testCreatePageInternal(true);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void testCreatePageWithDefaultContent() throws WCMException {
        this.context.build().resource("/apps/sample/templates/homepage/jcr:content", new Object[]{"sling:resourceType", "/apps/sample/components/page/homepage"});
        this.context.create().resource("/apps/sample/templates/homepage/jcr:content/node1", new Object[]{"prop1", "abc", "prop2", "def"});
        this.context.create().resource("/apps/sample/templates/homepage/jcr:content/node1/node11", new Object[]{"prop3", 55});
        this.context.create().resource("/apps/sample/templates/homepage/jcr:content/node2", new Object[]{"prop4", true});
        this.testCreatePageInternal(false);
        Resource pageResource = this.resourceResolver.getResource("/content/sample/en/test1/jcr:content");
        ValueMap props = pageResource.getValueMap();
        Assert.assertEquals((Object)"/apps/sample/components/page/homepage", (Object)props.get("sling:resourceType", String.class));
        Resource node1 = pageResource.getChild("node1");
        props = node1.getValueMap();
        Assert.assertEquals((Object)"abc", (Object)props.get("prop1", String.class));
        Assert.assertEquals((Object)"def", (Object)props.get("prop2", String.class));
        Resource node11 = pageResource.getChild("node1/node11");
        props = node11.getValueMap();
        Assert.assertEquals((long)55L, (long)((Integer)props.get("prop3", Integer.class)).intValue());
        Resource node2 = pageResource.getChild("node2");
        props = node2.getValueMap();
        Assert.assertEquals((Object)true, (Object)props.get("prop4", Boolean.class));
    }

    private void testCreatePageInternal(boolean autoSave) throws WCMException {
        Page page = this.pageManager.create("/content/sample/en", "test1", "/apps/sample/templates/homepage", "title1", autoSave);
        Assert.assertNotNull((Object)page);
        Resource pageResource = this.resourceResolver.getResource("/content/sample/en/test1/jcr:content");
        Assert.assertNotNull((Object)pageResource);
        ValueMap props = pageResource.getValueMap();
        Assert.assertEquals((Object)"title1", (Object)props.get("jcr:title", String.class));
        Assert.assertEquals((Object)"/apps/sample/templates/homepage", (Object)props.get("cq:template", String.class));
    }

    @Test
    public void testCreatePageWithDefaultContent_WTES23() throws Exception {
        this.context.load().json("/WTEST-23/sample_templates.json", "/content/templates");
        this.context.pageManager().create("/content", "", "/content/templates/sample-template", "Some title", true);
    }

    @Test
    public void testDeletePage() throws WCMException, PersistenceException {
        this.pageManager.delete(this.pageManager.getPage("/content/sample/en"), false);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.never())).commit();
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/jcr:content"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar/jcr:content"));
    }

    @Test
    public void testDeletePageWithAutoSave() throws WCMException, PersistenceException {
        this.pageManager.delete(this.pageManager.getPage("/content/sample/en"), false, true);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).commit();
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/jcr:content"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar/jcr:content"));
    }

    @Test
    public void testDeletePageShallow() throws WCMException, PersistenceException {
        this.pageManager.delete(this.pageManager.getPage("/content/sample/en"), true, false);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.never())).commit();
        Assert.assertNotNull((Object)this.resourceResolver.getResource("/content/sample/en"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/jcr:content"));
        Assert.assertNotNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar"));
        Assert.assertNotNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar/jcr:content"));
    }

    @Test
    public void testDeletePageShallowWithAutoSave() throws WCMException, PersistenceException {
        this.pageManager.delete(this.pageManager.getPage("/content/sample/en"), true, true);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).commit();
        Assert.assertNotNull((Object)this.resourceResolver.getResource("/content/sample/en"));
        Assert.assertNull((Object)this.resourceResolver.getResource("/content/sample/en/jcr:content"));
        Assert.assertNotNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar"));
        Assert.assertNotNull((Object)this.resourceResolver.getResource("/content/sample/en/toolbar/jcr:content"));
    }

    @Test
    public void testGetContainingPage() {
        Page containingPage = this.pageManager.getContainingPage("/content/sample/en");
        Assert.assertNotNull((Object)containingPage);
        Assert.assertEquals((Object)"/content/sample/en", (Object)containingPage.getPath());
        containingPage = this.pageManager.getContainingPage("/content/sample/en/jcr:content");
        Assert.assertNotNull((Object)containingPage);
        Assert.assertEquals((Object)"/content/sample/en", (Object)containingPage.getPath());
        containingPage = this.pageManager.getContainingPage("/content/sample/en/jcr:content/par/title_1");
        Assert.assertNotNull((Object)containingPage);
        Assert.assertEquals((Object)"/content/sample/en", (Object)containingPage.getPath());
        containingPage = this.pageManager.getContainingPage("/content/sample/en/toolbar/jcr:content/par");
        Assert.assertNotNull((Object)containingPage);
        Assert.assertEquals((Object)"/content/sample/en/toolbar", (Object)containingPage.getPath());
        containingPage = this.pageManager.getContainingPage("/content/sample");
        Assert.assertNull((Object)containingPage);
    }

    @Test
    public void testGetTemplate() {
        this.context.load().json("/json-import-samples/application.json", "/apps/sample");
        Assert.assertNotNull((Object)this.pageManager.getTemplate("/apps/sample/templates/homepage"));
        Assert.assertNull((Object)this.pageManager.getTemplate("/apps/sample/templates/nonExisting"));
    }

    @Test
    public void testCreatePageWithoutName() throws Exception {
        Page page = this.pageManager.create("/content/sample/en", null, "/apps/sample/templates/homepage", "Title 1");
        Assert.assertEquals((Object)"title-1", (Object)page.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreatePageWithInvalidName() throws Exception {
        this.pageManager.create("/content/sample/en", "title.1", "/apps/sample/templates/homepage", "Title 1");
    }

    @Test
    public void testCreatePageWithDuplicateName() throws Exception {
        Page page1 = this.pageManager.create("/content/sample/en", null, "/apps/sample/templates/homepage", "Title 1");
        Page page2 = this.pageManager.create("/content/sample/en", null, "/apps/sample/templates/homepage", "Title 1");
        Assert.assertEquals((Object)"title-1", (Object)page1.getName());
        Assert.assertTrue((boolean)StringUtils.startsWith((CharSequence)page2.getName(), (CharSequence)"title-1"));
        Assert.assertNotEquals((Object)page1.getPath(), (Object)page2.getPath());
    }

    @Test
    public void testTouch() throws WCMException, PersistenceException {
        if (ResourceResolverType.RESOURCERESOLVER_MOCK.equals((Object)this.context.resourceResolverType())) {
            return;
        }
        Resource resource = this.resourceResolver.getResource("/content/sample/en");
        ValueMap props = (ValueMap)resource.getChild("jcr:content").adaptTo(ModifiableValueMap.class);
        props.put((Object)"cq:lastModifiedBy", (Object)"user-with-other-name");
        props.put((Object)"cq:lastReplicated", (Object)Calendar.getInstance());
        props.put((Object)"cq:lastReplicatedBy", (Object)"user-with-other-name");
        props.put((Object)"cq:lastReplicationAction", (Object)"Activate");
        this.resourceResolver.commit();
        Calendar calendar = Calendar.getInstance();
        this.pageManager.touch((Node)resource.adaptTo(Node.class), true, calendar, true);
        ((ResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).commit();
        Page page = this.pageManager.getPage("/content/sample/en");
        Assert.assertEquals((long)calendar.getTimeInMillis(), (long)page.getLastModified().getTimeInMillis());
        Assert.assertEquals((Object)"admin", (Object)page.getLastModifiedBy());
        props = ((Resource)page.adaptTo(Resource.class)).getChild("jcr:content").getValueMap();
        Assert.assertNull((Object)props.get((Object)"cq:lastReplicated"));
        Assert.assertNull((Object)props.get((Object)"cq:lastReplicatedBy"));
        Assert.assertNull((Object)props.get((Object)"cq:lastReplicationAction"));
    }
}

