/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Rendition;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockRenditionTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Rendition rendition;

    @Before
    public void setUp() throws Exception {
        this.context.load().json("/json-import-samples/dam.json", "/content/dam/sample");
        Resource resource = this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/original");
        this.rendition = (Rendition)resource.adaptTo(Rendition.class);
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((Object)"original", (Object)this.rendition.getName());
        Assert.assertEquals((Object)"/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/original", (Object)this.rendition.getPath());
        Assert.assertEquals((Object)"image/jpeg", (Object)this.rendition.getMimeType());
        Assert.assertEquals((Object)"admin", (Object)this.rendition.getProperties().get("jcr:lastModifiedBy", String.class));
        Assert.assertNotNull((Object)this.rendition.hashCode());
    }

    @Test
    public void testAsset() {
        Assert.assertEquals((Object)"/content/dam/sample/portraits/scott_reynolds.jpg", (Object)this.rendition.getAsset().getPath());
    }

    @Test
    public void testStream() {
        Assert.assertNotNull((Object)this.rendition.getStream());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.rendition.getSize());
    }

    @Test
    public void testEquals() throws Exception {
        Rendition rendition1 = (Rendition)this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/original").adaptTo(Rendition.class);
        Rendition rendition2 = (Rendition)this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/original").adaptTo(Rendition.class);
        Rendition rendition3 = (Rendition)this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/cq5dam.thumbnail.48.48.png").adaptTo(Rendition.class);
        Assert.assertTrue((boolean)rendition1.equals(rendition2));
        Assert.assertFalse((boolean)rendition1.equals(rendition3));
    }
}

