/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import io.wcm.testing.mock.aem.models.SlingBindingsModel;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockAemSlingBindingsTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Page currentPage;
    private Resource currentResource;

    @Before
    public void setUp() throws Exception {
        this.context.addModelsForClasses(new Class[]{SlingBindingsModel.class});
        this.currentPage = this.context.create().page("/content/testPage");
        this.currentResource = this.context.create().resource(this.currentPage.getContentResource().getPath() + "/testResource", new Object[]{"sling:resourceType", "/apps/app1/components/component1"});
        this.context.create().resource("/apps/app1/components/component1", new Object[]{"jcr:primaryType", "cq:Component"});
    }

    @Test
    public void testBindings() {
        this.context.currentResource(this.currentResource);
        SlingBindingsModel model = (SlingBindingsModel)this.context.request().adaptTo(SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getResolver());
        Assert.assertNotNull((Object)model.getResource());
        Assert.assertNotNull((Object)model.getRequest());
        Assert.assertNotNull((Object)model.getResponse());
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK) {
            Assert.assertNull((Object)model.getCurrentNode());
            Assert.assertNull((Object)model.getcurrentSession());
        } else {
            Assert.assertNotNull((Object)model.getCurrentNode());
            Assert.assertNotNull((Object)model.getcurrentSession());
        }
        Assert.assertNotNull((Object)model.getComponentContext());
        Assert.assertNull((Object)model.getEditContext());
        Assert.assertNotNull((Object)model.getProperties());
        Assert.assertNotNull((Object)model.getPageManager());
        Assert.assertNotNull((Object)model.getCurrentPage());
        Assert.assertNotNull((Object)model.getResourcePage());
        Assert.assertNotNull((Object)model.getPageProperties());
        Assert.assertNotNull((Object)model.getComponent());
        Assert.assertNotNull((Object)model.getDesigner());
        Assert.assertNotNull((Object)model.getCurrentDesign());
        Assert.assertNotNull((Object)model.getResourceDesign());
        Assert.assertNotNull((Object)model.getCurrentStyle());
    }

    @Test
    public void testBindings_EditMode() {
        WCMMode.EDIT.toRequest((ServletRequest)this.context.request());
        this.context.currentResource(this.currentResource);
        SlingBindingsModel model = (SlingBindingsModel)this.context.request().adaptTo(SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getResolver());
        Assert.assertNotNull((Object)model.getResource());
        Assert.assertNotNull((Object)model.getRequest());
        Assert.assertNotNull((Object)model.getResponse());
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK) {
            Assert.assertNull((Object)model.getCurrentNode());
            Assert.assertNull((Object)model.getcurrentSession());
        } else {
            Assert.assertNotNull((Object)model.getCurrentNode());
            Assert.assertNotNull((Object)model.getcurrentSession());
        }
        Assert.assertNotNull((Object)model.getComponentContext());
        Assert.assertNotNull((Object)model.getEditContext());
        Assert.assertNotNull((Object)model.getProperties());
        Assert.assertNotNull((Object)model.getPageManager());
        Assert.assertNotNull((Object)model.getCurrentPage());
        Assert.assertNotNull((Object)model.getResourcePage());
        Assert.assertNotNull((Object)model.getPageProperties());
        Assert.assertNotNull((Object)model.getComponent());
        Assert.assertNotNull((Object)model.getDesigner());
        Assert.assertNotNull((Object)model.getCurrentDesign());
        Assert.assertNotNull((Object)model.getResourceDesign());
        Assert.assertNotNull((Object)model.getCurrentStyle());
    }
}

