/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.adobe.granite.asset.api.AssetRelation;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetHandlerException;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(service={AssetHandler.class})
public final class MockAssetHandler
implements AssetHandler {
    static final String JPEG_MIME_TYPE = "image/jpeg";
    static final String PNG_MIME_TYPE = "image/png";
    static final String GIF_MIME_TYPE = "image/gif";
    static final String TIFF_MIME_TYPE = "image/tiff";
    static final String SVG_MIME_TYPE = "image/svg+xml";
    private static final String[] MIME_TYPES = new String[]{"image/jpeg", "image/png", "image/gif", "image/tiff", "image/svg+xml"};

    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    public BufferedImage getImage(Rendition rendition, Dimension maxDimension) throws IOException {
        try (InputStream is = rendition.getStream();){
            Layer layer = new Layer(is, maxDimension);
            BufferedImage bufferedImage = layer.getImage();
            return bufferedImage;
        }
    }

    public boolean canHandleSubAssets() {
        return false;
    }

    public void createThumbnails(Asset asset) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createThumbnails(Asset asset, Collection<ThumbnailConfig> configs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createThumbnails(Asset asset, Rendition rendition, Collection<ThumbnailConfig> configs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void exportAsset(Asset asset, OutputStream os) throws AssetHandlerException {
        throw new UnsupportedOperationException();
    }

    public ExtractedMetadata extractMetadata(Asset asset) {
        throw new UnsupportedOperationException();
    }

    public Iterator<? extends AssetRelation> processRelated(Asset asset) {
        throw new UnsupportedOperationException();
    }

    public List<String> processSubAssets(Asset asset) {
        throw new UnsupportedOperationException();
    }
}

