/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.granite;

import com.adobe.granite.workflow.collection.ResourceCollection;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import io.wcm.testing.mock.aem.granite.MockResourceCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.impl.JcrWorkspaceFilter;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceCollectionManager.class})
public final class MockResourceCollectionManager
implements ResourceCollectionManager {
    private static final Logger log = LoggerFactory.getLogger(MockResourceCollectionManager.class);

    public ResourceCollection createCollection(Node node) {
        try {
            if (node.isNodeType("vlt:PackageDefinition") && node.hasNode("filter")) {
                String packagePath = node.getParent().getParent().getPath();
                DefaultWorkspaceFilter packageFilter = JcrWorkspaceFilter.loadFilter((Node)node);
                return new MockResourceCollection(packagePath, (WorkspaceFilter)packageFilter, node.getSession());
            }
            log.info("Resource collection at {} is not a package.", (Object)node.getPath());
        }
        catch (RepositoryException ex) {
            log.warn("Unable to create collection.", (Throwable)ex);
        }
        return null;
    }

    public List<ResourceCollection> getCollectionsForNode(Node baseNode) {
        TreeMap<String, ResourceCollection> resourceCollections = new TreeMap<String, ResourceCollection>();
        try {
            this.getCollectionsForNode(baseNode, resourceCollections);
        }
        catch (RepositoryException ex) {
            log.warn("Unable to get resource collections for node.", (Throwable)ex);
        }
        return new ArrayList<ResourceCollection>(resourceCollections.values());
    }

    private void getCollectionsForNode(Node baseNode, Map<String, ResourceCollection> resourceCollections) throws RepositoryException {
        if (baseNode.isNodeType("vlt:PackageDefinition")) {
            ResourceCollection collection = this.createCollection(baseNode);
            if (collection != null) {
                resourceCollections.put(baseNode.getPath(), collection);
            }
        } else {
            NodeIterator nodes = baseNode.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                this.getCollectionsForNode(node, resourceCollections);
            }
        }
    }

    public List<ResourceCollection> getCollections(Session session) {
        throw new UnsupportedOperationException();
    }
}

