/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.collect.ImmutableMap;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockContentPolicyManagerTest {
    private static final String RT_TEST = "app1/components/test";
    private static final String RT_TEST_2 = "/apps/app1/components/test2";
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private ContentPolicyManager underTest;
    private Page page;

    @Before
    public void setUp() {
        this.page = this.context.create().page("/content/test");
        this.underTest = (ContentPolicyManager)this.context.resourceResolver().adaptTo(ContentPolicyManager.class);
    }

    @Test
    public void testWithoutPolicy() {
        this.context.currentResource(this.context.create().resource(this.page, "resource1", new Object[]{"sling:resourceType", RT_TEST}));
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        ContentPolicy policy = this.underTest.getPolicy(componentContext);
        Assert.assertNull((Object)policy);
        Style style = this.getStyle();
        Assert.assertNull((Object)style.get("prop1", String.class));
    }

    @Test
    public void testWithPolicy() {
        this.context.currentResource(this.context.create().resource(this.page, "resource1", new Object[]{"sling:resourceType", RT_TEST}));
        this.context.contentPolicyMapping(RT_TEST, new Object[]{"prop1", "value1"});
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        ContentPolicy policy = this.underTest.getPolicy(componentContext);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((Object)"value1", (Object)policy.getProperties().get("prop1", String.class));
        Style style = this.getStyle();
        Assert.assertEquals((Object)"value1", (Object)style.get("prop1", String.class));
        this.context.contentPolicyMapping(RT_TEST, new Object[]{"prop1", "value2"});
        policy = this.underTest.getPolicy(componentContext);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((Object)"value2", (Object)policy.getProperties().get("prop1", String.class));
        style = this.getStyle();
        Assert.assertEquals((Object)"value2", (Object)style.get("prop1", String.class));
    }

    @Test
    public void testWithoutResourceType() {
        this.context.currentResource(this.context.create().resource(this.page, "resource1"));
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        ContentPolicy policy = this.underTest.getPolicy(componentContext);
        Assert.assertNull((Object)policy);
        Style style = this.getStyle();
        Assert.assertNull((Object)style.get("prop1", String.class));
    }

    @Test
    public void testWithAbsoluteResourceType() {
        this.context.currentResource(this.context.create().resource(this.page, "resource1", new Object[]{"sling:resourceType", RT_TEST_2}));
        this.context.contentPolicyMapping(RT_TEST_2, new Object[]{"prop1", "value1"});
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        ContentPolicy policy = this.underTest.getPolicy(componentContext);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((Object)"value1", (Object)policy.getProperties().get("prop1", String.class));
        Style style = this.getStyle();
        Assert.assertEquals((Object)"value1", (Object)style.get("prop1", String.class));
    }

    @Test
    public void testWithNestedResources() {
        this.context.currentResource(this.context.create().resource(this.page, "resource1", new Object[]{"sling:resourceType", RT_TEST}));
        this.context.contentPolicyMapping(RT_TEST, (Map)ImmutableMap.of((Object)"prop1", (Object)"value1", (Object)"child1", (Object)ImmutableMap.of((Object)"prop2", (Object)"value2", (Object)"child2", (Object)ImmutableMap.of((Object)"prop3", (Object)"value3"))));
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        ContentPolicy policy = this.underTest.getPolicy(componentContext);
        Assert.assertNotNull((Object)policy);
        Assert.assertEquals((Object)"value1", (Object)policy.getProperties().get("prop1", String.class));
        Resource resource = (Resource)policy.adaptTo(Resource.class);
        Assert.assertEquals((Object)"value1", (Object)resource.getValueMap().get("prop1", String.class));
        Resource child1 = resource.getChild("child1");
        Assert.assertEquals((Object)"value2", (Object)child1.getValueMap().get("prop2", String.class));
        Resource child2 = child1.getChild("child2");
        Assert.assertEquals((Object)"value3", (Object)child2.getValueMap().get("prop3", String.class));
    }

    private Style getStyle() {
        SlingBindings bindings = (SlingBindings)this.context.request().getAttribute(SlingBindings.class.getName());
        if (bindings != null) {
            return (Style)bindings.get((Object)"currentStyle");
        }
        return null;
    }
}

