/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import io.wcm.testing.mock.aem.MockContentPolicy;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Calendar;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MockContentPolicyTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Test
    public void testProperties() {
        Calendar timestamp = Calendar.getInstance();
        Resource resource = this.context.create().resource("/content/test", new Object[]{"jcr:lastModified", timestamp, "jcr:lastModifiedBy", "user1", "prop1", "value1"});
        MockContentPolicy underTest = new MockContentPolicy(resource);
        Assert.assertEquals((Object)"value1", (Object)underTest.getProperties().get("prop1", String.class));
        Assert.assertEquals((long)timestamp.getTimeInMillis(), (long)underTest.getLastModified().getTimeInMillis());
        Assert.assertEquals((Object)"user1", (Object)underTest.getLastModifiedBy());
        Assert.assertEquals((Object)resource.getPath(), (Object)((Resource)underTest.adaptTo(Resource.class)).getPath());
        Assert.assertNull((Object)underTest.adaptTo(Object.class));
    }

    @Test
    public void testEmpty() {
        Resource resource = this.context.create().resource("/content/test");
        MockContentPolicy underTest = new MockContentPolicy(resource);
        Assert.assertNull((Object)underTest.getProperties().get("prop1", String.class));
        Assert.assertNull((Object)underTest.getLastModified());
        Assert.assertNull((Object)underTest.getLastModifiedBy());
    }
}

