/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Template;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockTemplateTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Template template;

    @Before
    public void setUp() throws Exception {
        this.context.load().json("/json-import-samples/application.json", "/apps/sample");
        Resource resource = this.context.resourceResolver().getResource("/apps/sample/templates/homepage");
        this.template = (Template)resource.adaptTo(Template.class);
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((Object)"/apps/sample/templates/homepage", (Object)this.template.getPath());
        Assert.assertEquals((Object)"homepage", (Object)this.template.getName());
        Assert.assertEquals((Object)"Sample Homepage", (Object)this.template.getTitle());
        Assert.assertEquals((Object)"Homepage", (Object)this.template.getShortTitle());
        Assert.assertNotNull((Object)this.template.getDescription());
        Assert.assertNull((Object)this.template.getIconPath());
        Assert.assertEquals((Object)"/apps/sample/templates/homepage/thumbnail.png", (Object)this.template.getThumbnailPath());
        Assert.assertEquals((Object)110L, (Object)this.template.getRanking());
        Assert.assertNotNull((Object)this.template.hashCode());
    }

    @Test
    public void testEquals() throws Exception {
        Template template1 = (Template)this.context.resourceResolver().getResource("/apps/sample/templates/homepage").adaptTo(Template.class);
        Template template2 = (Template)this.context.resourceResolver().getResource("/apps/sample/templates/homepage").adaptTo(Template.class);
        Template template3 = (Template)this.context.resourceResolver().getResource("/apps/sample/templates/contentpage").adaptTo(Template.class);
        Assert.assertTrue((boolean)template1.equals(template2));
        Assert.assertFalse((boolean)template1.equals(template3));
    }
}

