/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AemContextImplTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private String contentRoot;
    private String appsRoot;

    @Before
    public void setUp() throws Exception {
        this.contentRoot = this.context.uniqueRoot().content() + "/sample";
        this.appsRoot = this.context.uniqueRoot().apps() + "/sample";
        ContentLoader contentLoader = this.context.load();
        contentLoader.json("/json-import-samples/application.json", this.appsRoot);
        contentLoader.json("/json-import-samples/content.json", this.contentRoot);
    }

    @After
    public void tearDown() throws Exception {
        this.context.tearDown();
    }

    @Test
    public void testContextObjects() {
        Assert.assertNotNull((Object)this.context.pageManager());
    }

    @Test
    public void testSetCurrentPage() {
        this.context.currentPage(this.contentRoot + "/toolbar/profiles");
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/profiles"), (Object)this.context.currentPage().getPath());
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/profiles/jcr:content"), (Object)this.context.currentResource().getPath());
        this.context.currentPage(this.context.pageManager().getPage(this.contentRoot + "/toolbar"));
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar"), (Object)this.context.currentPage().getPath());
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/jcr:content"), (Object)this.context.currentResource().getPath());
        this.context.currentPage(null);
        Assert.assertNull((Object)this.context.currentPage());
        this.context.currentPage(null);
        Assert.assertNull((Object)this.context.currentPage());
    }

    @Test
    public void testSetCurrentPageWithResourceFromOtherPage() {
        Resource otherResource = this.context.resourceResolver().getResource(this.contentRoot + "/jcr:content/par");
        this.context.currentPage(this.contentRoot + "/toolbar/profiles");
        this.context.currentResource(otherResource);
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/profiles"), (Object)this.context.currentPage().getPath());
        Assert.assertEquals((Object)otherResource.getPath(), (Object)this.context.currentResource().getPath());
        this.context.currentPage(this.context.pageManager().getPage(this.contentRoot + "/toolbar"));
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar"), (Object)this.context.currentPage().getPath());
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/jcr:content"), (Object)this.context.currentResource().getPath());
        this.context.currentPage(null);
        Assert.assertNull((Object)this.context.currentPage());
        this.context.currentPage(null);
        Assert.assertNull((Object)this.context.currentPage());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCurrentPageNonExisting() {
        this.context.currentPage("/non/existing");
    }

    @Test
    public void testServiceLogin() throws Exception {
        ResourceResolverFactory resourceResolverFactory = (ResourceResolverFactory)this.context.getService(ResourceResolverFactory.class);
        ResourceResolver resolver = resourceResolverFactory.getServiceResourceResolver(null);
        Assert.assertNotNull((Object)resolver);
        resolver.close();
    }

    @Test
    public void testResourceResolverFactoryActivatorConfig() {
        String mappedPath = this.context.resourceResolver().map(this.contentRoot + "/toolbar/profiles");
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/profiles"), (Object)mappedPath);
    }

    @Test
    public void testSetCurrentPageViaSetResource_String() {
        this.context.currentResource(this.contentRoot + "/toolbar/profiles/jcr:content");
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/profiles"), (Object)this.context.currentPage().getPath());
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/profiles/jcr:content"), (Object)this.context.currentResource().getPath());
    }

    @Test
    public void testSetCurrentPageViaSetResource_Resource() {
        this.context.currentResource(this.context.resourceResolver().getResource(this.contentRoot + "/toolbar/jcr:content"));
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar"), (Object)this.context.currentPage().getPath());
        Assert.assertEquals((Object)(this.contentRoot + "/toolbar/jcr:content"), (Object)this.context.currentResource().getPath());
    }
}

