/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.junit.AemContext;
import io.wcm.testing.mock.aem.junit.AemContextCallback;
import java.io.IOException;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.jetbrains.annotations.NotNull;

public final class TestAemContext {
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    public static final ResourceResolverType[] ALL_TYPES = new ResourceResolverType[]{ResourceResolverType.JCR_MOCK, ResourceResolverType.RESOURCERESOLVER_MOCK, ResourceResolverType.JCR_OAK};

    private TestAemContext() {
    }

    @NotNull
    public static AemContext newAemContext() {
        return TestAemContext.newAemContext(ALL_TYPES);
    }

    @NotNull
    public static AemContext newAemContext(ResourceResolverType ... resourceResolverTypes) {
        return new AemContext(new SetUpCallback(), resourceResolverTypes);
    }

    private static final class SetUpCallback
    implements AemContextCallback {
        private SetUpCallback() {
        }

        public void execute(@NotNull AemContext context) throws PersistenceException, IOException {
            try {
                NodeTypeDefinitionScanner.get().register((Session)context.resourceResolver().adaptTo(Session.class), (List)ImmutableList.of((Object)"SLING-INF/nodetypes/aem-core-replication.cnd", (Object)"SLING-INF/nodetypes/aem-tagging.cnd", (Object)"SLING-INF/nodetypes/aem-commons.cnd", (Object)"SLING-INF/nodetypes/aem-dam.cnd", (Object)"SLING-INF/nodetypes/aem-dam1.cnd", (Object)"SLING-INF/nodetypes/vlt.cnd"), context.resourceResolverType().getNodeTypeMode());
            }
            catch (RepositoryException ex) {
                throw new RuntimeException("Unable to register AEM nodetypes: " + ex.getMessage(), ex);
            }
        }
    }
}

