/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.image.Layer;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockAssetHandlerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private AssetStore assetStore;

    @Before
    public void setUp() {
        this.assetStore = (AssetStore)this.context.getService(AssetStore.class);
        Assert.assertNotNull((String)"Asset Store service not present", (Object)this.assetStore);
    }

    @Test
    public void testAssetHandler_JPEG() throws Exception {
        this.assertAssertHandlerImage("/dam/filetype/sample.jpg", "image/jpeg", 100, 50);
    }

    @Test
    public void testAssetHandler_GIF() throws Exception {
        this.assertAssertHandlerImage("/dam/filetype/sample.gif", "image/gif", 100, 50);
    }

    @Test
    public void testAssetHandler_PNG() throws Exception {
        this.assertAssertHandlerImage("/dam/filetype/sample.png", "image/png", 100, 50);
    }

    @Test
    public void testAssetHandler_TIFF() throws Exception {
        this.assertAssertHandlerImage("/dam/filetype/sample.tif", "image/tiff", 100, 50);
    }

    @Test
    public void testAssetHandler_SVG() throws Exception {
        this.assertAssertHandlerImage("/dam/filetype/sample.svg", "image/svg+xml", 100, 50);
    }

    private void assertAssertHandlerImage(String classpathResource, String contentType, int width, int height) throws IOException {
        String filename = FilenameUtils.getName((String)classpathResource);
        Asset asset = this.context.create().asset("/content/dam/" + filename, classpathResource, contentType);
        AssetHandler assetHandler = this.assetStore.getAssetHandler(contentType);
        Assert.assertNotNull((Object)assetHandler);
        BufferedImage bufferedImage = assetHandler.getImage(asset.getOriginal());
        Layer layer = new Layer(bufferedImage);
        Assert.assertEquals((long)width, (long)layer.getWidth());
        Assert.assertEquals((long)height, (long)layer.getHeight());
    }
}

