/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Cell;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.wcm.testing.mock.aem.MockComponentContext;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class MockComponentContextTest {
    private static final String COMPONENT_RESOURCE_TYPE = "/apps/test/components/component1";
    private static final String PAGE_PATH = "/content/page1";
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Page page;
    private Resource resource;
    private ComponentContext underTest;

    @Before
    public void setUp() {
        this.context.create().resource(COMPONENT_RESOURCE_TYPE, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"cq:Component").build());
        this.page = this.context.create().page(PAGE_PATH);
        this.resource = this.context.create().resource(this.page.getContentResource().getPath() + "/comp1", (Map)ImmutableMap.builder().put((Object)"sling:resourceType", (Object)COMPONENT_RESOURCE_TYPE).build());
        this.context.currentPage(this.page);
        this.context.currentResource(this.resource);
        this.underTest = WCMUtils.getComponentContext((ServletRequest)this.context.request());
    }

    @Test
    public void testGetRoot() {
        Assert.assertTrue((boolean)this.underTest.isRoot());
        Assert.assertSame((Object)this.underTest, (Object)this.underTest.getRoot());
    }

    @Test
    public void testGetParent() {
        Assert.assertNull((Object)this.underTest.getParent());
    }

    @Test
    public void testGetPage() {
        Assert.assertEquals((Object)this.page.getPath(), (Object)this.underTest.getPage().getPath());
    }

    @Test
    public void testGetResource() {
        Assert.assertEquals((Object)this.resource.getPath(), (Object)this.underTest.getResource().getPath());
    }

    @Test
    public void testGetComponent() {
        Component component = this.underTest.getComponent();
        Assert.assertEquals((Object)COMPONENT_RESOURCE_TYPE, (Object)component.getPath());
    }

    @Test
    public void testAttributes() {
        this.underTest.setAttribute("attr1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.underTest.getAttribute("attr1"));
    }

    @Test
    public void testHasDecoration() {
        Assert.assertTrue((boolean)this.underTest.hasDecoration());
        this.underTest.setDecorate(false);
        Assert.assertFalse((boolean)this.underTest.hasDecoration());
    }

    @Test
    public void testGetDecorationTagName() {
        this.underTest.setDecorationTagName("xyz");
        Assert.assertEquals((Object)"xyz", (Object)this.underTest.getDecorationTagName());
    }

    @Test
    public void testGetDefaultDecorationTagName() {
        this.underTest.setDefaultDecorationTagName("xyz");
        Assert.assertEquals((Object)"xyz", (Object)this.underTest.getDefaultDecorationTagName());
    }

    @Test
    public void testGetEditContext() {
        Assert.assertNull((Object)this.underTest.getEditContext());
    }

    @Test
    public void testGetCell() {
        Assert.assertNotNull((Object)this.underTest.getCell());
        Cell newCell = (Cell)Mockito.mock(Cell.class);
        ((MockComponentContext)this.underTest).setCell(newCell);
        Assert.assertSame((Object)newCell, (Object)this.underTest.getCell());
    }

    @Test
    public void testGetCssClassNames() {
        Assert.assertNotNull((Object)this.underTest.getCssClassNames());
        ImmutableSet classNames = ImmutableSet.of((Object)"class");
        ((MockComponentContext)this.underTest).setCssClassNames((Set)classNames);
        Assert.assertEquals((Object)classNames, (Object)this.underTest.getCssClassNames());
    }
}

