/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Language;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import io.wcm.testing.mock.aem.MockLanguageManager;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockLanguageManagerTest {
    private static final String SITE_ROOT = "/content/sample";
    private static final String ENGLISH_HOMEPAGE = String.join((CharSequence)"/", "/content/sample", "en");
    private static final String FRENCH_HOMEPAGE = String.join((CharSequence)"/", "/content/sample", "fr");
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Before
    public void setUp() {
        ContentLoader contentLoader = this.context.load();
        contentLoader.json("/json-import-samples/language-content.json", SITE_ROOT);
    }

    @Test
    public void getLanguage() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Locale englishLocale = languageManager.getLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(ENGLISH_HOMEPAGE + "/subpage/jcr:content")));
        Assert.assertNotNull((Object)englishLocale);
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)englishLocale);
        Locale frenchLocale = languageManager.getLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(FRENCH_HOMEPAGE + "/subpage/jcr:content")));
        Assert.assertNotNull((Object)frenchLocale);
        Assert.assertEquals((Object)Locale.JAPANESE, (Object)frenchLocale);
        Locale rootLocale = languageManager.getLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(SITE_ROOT)));
        Assert.assertNull((Object)rootLocale);
    }

    @Test
    public void getCqLanguage() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Language englishLocale = languageManager.getCqLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(ENGLISH_HOMEPAGE + "/subpage/jcr:content")), false);
        Assert.assertNotNull((Object)englishLocale);
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)englishLocale.getLocale());
        Language frenchLocale = languageManager.getCqLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(FRENCH_HOMEPAGE + "/subpage/jcr:content")), false);
        Assert.assertNotNull((Object)frenchLocale);
        Assert.assertEquals((Object)Locale.FRENCH, (Object)frenchLocale.getLocale());
        Language rootLocale = languageManager.getCqLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(SITE_ROOT)), false);
        Assert.assertNull((Object)rootLocale);
    }

    @Test
    public void getCqLanguage_respectContent() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Language englishLocale = languageManager.getCqLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(ENGLISH_HOMEPAGE + "/subpage/jcr:content")));
        Assert.assertNotNull((Object)englishLocale);
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)englishLocale.getLocale());
        Language frenchLocale = languageManager.getCqLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(FRENCH_HOMEPAGE + "/subpage/jcr:content")));
        Assert.assertNotNull((Object)frenchLocale);
        Assert.assertEquals((Object)Locale.JAPANESE, (Object)frenchLocale.getLocale());
        Language rootLocale = languageManager.getCqLanguage(Objects.requireNonNull(this.context.resourceResolver().getResource(SITE_ROOT)));
        Assert.assertNull((Object)rootLocale);
    }

    @Test
    public void getLanguageRoot() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Page englishLanguageRoot = languageManager.getLanguageRoot(Objects.requireNonNull(this.context.resourceResolver().getResource(ENGLISH_HOMEPAGE + "/subpage/jcr:content")));
        Assert.assertNotNull((Object)englishLanguageRoot);
        Assert.assertEquals((Object)ENGLISH_HOMEPAGE, (Object)englishLanguageRoot.getPath());
        Page frenchLanguageRoot = languageManager.getLanguageRoot(Objects.requireNonNull(this.context.resourceResolver().getResource(FRENCH_HOMEPAGE + "/subpage/jcr:content")));
        Assert.assertNotNull((Object)frenchLanguageRoot);
        Assert.assertEquals((Object)FRENCH_HOMEPAGE, (Object)frenchLanguageRoot.getPath());
    }

    @Test
    public void getLanguageRoots() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Collection roots = languageManager.getLanguageRoots(this.context.resourceResolver(), ENGLISH_HOMEPAGE + "/subpage/jcr:content");
        Assert.assertNotNull((Object)roots);
        Assert.assertArrayEquals((Object[])new String[]{ENGLISH_HOMEPAGE, FRENCH_HOMEPAGE}, (Object[])roots.stream().map(Page::getPath).toArray());
        Collection roots2 = languageManager.getLanguageRoots(this.context.resourceResolver(), FRENCH_HOMEPAGE + "/subpage/jcr:content");
        Assert.assertNotNull((Object)roots2);
        Assert.assertArrayEquals((Object[])new String[]{ENGLISH_HOMEPAGE, FRENCH_HOMEPAGE}, (Object[])roots2.stream().map(Page::getPath).toArray());
        Collection roots4 = languageManager.getLanguageRoots(this.context.resourceResolver(), SITE_ROOT);
        Assert.assertNotNull((Object)roots4);
        Assert.assertArrayEquals((Object[])new Page[0], (Object[])roots4.toArray(new Page[0]));
        Collection nullPath = languageManager.getLanguageRoots(this.context.resourceResolver(), null);
        Assert.assertArrayEquals((Object[])new Page[0], (Object[])nullPath.toArray(new Page[0]));
        Collection rootPath = languageManager.getLanguageRoots(this.context.resourceResolver(), "/");
        Assert.assertArrayEquals((Object[])new Page[0], (Object[])rootPath.toArray(new Page[0]));
    }

    @Test
    public void getLanguages() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Collection locales = languageManager.getLanguages(this.context.resourceResolver(), ENGLISH_HOMEPAGE + "/subpage/jcr:content");
        Assert.assertNotNull((Object)locales);
        Assert.assertArrayEquals((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}, (Object[])locales.toArray(new Locale[0]));
        Collection locales2 = languageManager.getLanguages(this.context.resourceResolver(), FRENCH_HOMEPAGE + "/subpage/jcr:content");
        Assert.assertNotNull((Object)locales2);
        Assert.assertArrayEquals((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}, (Object[])locales2.toArray(new Locale[0]));
        Collection locales3 = languageManager.getLanguages(this.context.resourceResolver(), "/does/not/exist");
        Assert.assertNotNull((Object)locales3);
        Assert.assertArrayEquals((Object[])new Locale[0], (Object[])locales3.toArray(new Locale[0]));
        Collection locales4 = languageManager.getLanguages(this.context.resourceResolver(), SITE_ROOT);
        Assert.assertNotNull((Object)locales4);
        Assert.assertArrayEquals((Object[])new Locale[0], (Object[])locales4.toArray(new Locale[0]));
    }

    @Test
    public void getCqLanguages() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Collection languages = languageManager.getCqLanguages(this.context.resourceResolver(), ENGLISH_HOMEPAGE + "/subpage/jcr:content");
        Assert.assertNotNull((Object)languages);
        Assert.assertArrayEquals((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}, (Object[])languages.stream().map(Language::getLocale).toArray());
        Collection languages2 = languageManager.getCqLanguages(this.context.resourceResolver(), FRENCH_HOMEPAGE + "/subpage/jcr:content");
        Assert.assertNotNull((Object)languages2);
        Assert.assertArrayEquals((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}, (Object[])languages2.stream().map(Language::getLocale).toArray());
        Collection languages3 = languageManager.getCqLanguages(this.context.resourceResolver(), "/does/not/exist");
        Assert.assertNotNull((Object)languages3);
        Assert.assertArrayEquals((Object[])new Locale[0], (Object[])languages3.stream().map(Language::getLocale).toArray());
        Collection languages4 = languageManager.getCqLanguages(this.context.resourceResolver(), SITE_ROOT);
        Assert.assertNotNull((Object)languages4);
        Assert.assertArrayEquals((Object[])new Locale[0], (Object[])languages4.stream().map(Language::getLocale).toArray());
    }

    @Test
    public void getAdjacentLanguageInfo() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Map adjacentLanguageInfo = languageManager.getAdjacentLanguageInfo(this.context.resourceResolver(), ENGLISH_HOMEPAGE + "/subpage2");
        Assert.assertNotNull((Object)adjacentLanguageInfo);
        Assert.assertArrayEquals((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}, (Object[])adjacentLanguageInfo.keySet().stream().map(Language::getLocale).toArray());
        LanguageManager.Info englishInfo = adjacentLanguageInfo.entrySet().stream().filter(e -> ((Language)e.getKey()).getLocale().equals(Locale.ENGLISH)).map(Map.Entry::getValue).findFirst().orElse(null);
        Assert.assertNotNull((Object)englishInfo);
        Assert.assertEquals((Object)(ENGLISH_HOMEPAGE + "/subpage2"), (Object)englishInfo.getPath());
        Assert.assertEquals((long)0L, (long)englishInfo.getLastModified());
        Assert.assertTrue((boolean)englishInfo.exists());
        Assert.assertTrue((boolean)englishInfo.hasContent());
        LanguageManager.Info frenchInfo = adjacentLanguageInfo.entrySet().stream().filter(e -> ((Language)e.getKey()).getLocale().equals(Locale.FRENCH)).map(Map.Entry::getValue).findFirst().orElse(null);
        Assert.assertNotNull((Object)frenchInfo);
        Assert.assertEquals((Object)(FRENCH_HOMEPAGE + "/subpage2"), (Object)frenchInfo.getPath());
        Assert.assertEquals((long)0L, (long)frenchInfo.getLastModified());
        Assert.assertFalse((boolean)frenchInfo.exists());
        Assert.assertFalse((boolean)frenchInfo.hasContent());
        Map nonExisting = languageManager.getAdjacentLanguageInfo(this.context.resourceResolver(), "/does/not/exist");
        Assert.assertNull((Object)nonExisting);
        Map nullPath = languageManager.getAdjacentLanguageInfo(this.context.resourceResolver(), null);
        Assert.assertNull((Object)nullPath);
        Map rootPath = languageManager.getAdjacentLanguageInfo(this.context.resourceResolver(), "/");
        Assert.assertNull((Object)rootPath);
    }

    @Test
    public void getAdjacentInfo() {
        MockLanguageManager languageManager = new MockLanguageManager();
        Map adjacentInfo = languageManager.getAdjacentInfo(this.context.resourceResolver(), ENGLISH_HOMEPAGE + "/subpage2");
        Assert.assertNotNull((Object)adjacentInfo);
        Assert.assertArrayEquals((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}, (Object[])adjacentInfo.keySet().toArray());
        LanguageManager.Info englishInfo = adjacentInfo.entrySet().stream().filter(e -> ((Locale)e.getKey()).equals(Locale.ENGLISH)).map(Map.Entry::getValue).findFirst().orElse(null);
        Assert.assertNotNull((Object)englishInfo);
        Assert.assertEquals((Object)(ENGLISH_HOMEPAGE + "/subpage2"), (Object)englishInfo.getPath());
        Assert.assertEquals((long)0L, (long)englishInfo.getLastModified());
        Assert.assertTrue((boolean)englishInfo.exists());
        Assert.assertTrue((boolean)englishInfo.hasContent());
        LanguageManager.Info frenchInfo = adjacentInfo.entrySet().stream().filter(e -> ((Locale)e.getKey()).equals(Locale.FRENCH)).map(Map.Entry::getValue).findFirst().orElse(null);
        Assert.assertNotNull((Object)frenchInfo);
        Assert.assertEquals((Object)(FRENCH_HOMEPAGE + "/subpage2"), (Object)frenchInfo.getPath());
        Assert.assertEquals((long)0L, (long)frenchInfo.getLastModified());
        Assert.assertFalse((boolean)frenchInfo.exists());
        Assert.assertFalse((boolean)frenchInfo.hasContent());
        Map nonExisting = languageManager.getAdjacentInfo(this.context.resourceResolver(), "/does/not/exist");
        Assert.assertNull((Object)nonExisting);
        Map nullPath = languageManager.getAdjacentInfo(this.context.resourceResolver(), null);
        Assert.assertNull((Object)nullPath);
        Map rootPath = languageManager.getAdjacentInfo(this.context.resourceResolver(), "/");
        Assert.assertNull((Object)rootPath);
    }
}

