/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import io.wcm.testing.mock.aem.context.ResourceTypeForcingResourceWrapper;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import io.wcm.testing.mock.aem.models.SlingBindingsModel;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockAemSlingBindingsTest {
    private static final String COMPONENT_RESOURCE_SUPER_TYPE = "app1/components/component2";
    private static final String COMPONENT_RESOURCE_TYPE = "app1/components/component1";
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Page currentPage;
    private Resource currentResource;

    @Before
    public void setUp() throws Exception {
        this.context.addModelsForClasses(new Class[]{SlingBindingsModel.class});
        this.currentPage = this.context.create().page("/content/testPage");
        this.currentResource = this.context.create().resource(this.currentPage.getContentResource().getPath() + "/testResource", new Object[]{"sling:resourceType", COMPONENT_RESOURCE_TYPE});
        this.context.create().resource("/apps/app1/components/component2", new Object[]{"jcr:primaryType", "cq:Component"});
        this.context.create().resource("/apps/app1/components/component1", new Object[]{"jcr:primaryType", "cq:Component", "sling:resourceSuperType", COMPONENT_RESOURCE_SUPER_TYPE});
    }

    @Test
    public void testBindings() {
        this.context.currentResource(this.currentResource);
        SlingBindingsModel model = (SlingBindingsModel)this.context.request().adaptTo(SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getResolver());
        Assert.assertNotNull((Object)model.getResource());
        Assert.assertNotNull((Object)model.getRequest());
        Assert.assertNotNull((Object)model.getResponse());
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK || this.context.resourceResolverType() == ResourceResolverType.RESOURCEPROVIDER_MOCK) {
            Assert.assertNull((Object)model.getCurrentNode());
            Assert.assertNull((Object)model.getcurrentSession());
        } else {
            Assert.assertNotNull((Object)model.getCurrentNode());
            Assert.assertNotNull((Object)model.getcurrentSession());
        }
        Assert.assertNotNull((Object)model.getComponentContext());
        Assert.assertNull((Object)model.getEditContext());
        Assert.assertNotNull((Object)model.getProperties());
        Assert.assertNotNull((Object)model.getPageManager());
        Assert.assertNotNull((Object)model.getCurrentPage());
        Assert.assertNotNull((Object)model.getResourcePage());
        Assert.assertNotNull((Object)model.getPageProperties());
        Assert.assertNotNull((Object)model.getComponent());
        Assert.assertNotNull((Object)model.getDesigner());
        Assert.assertNotNull((Object)model.getCurrentDesign());
        Assert.assertNotNull((Object)model.getResourceDesign());
        Assert.assertNotNull((Object)model.getCurrentStyle());
    }

    @Test
    public void testBindings_resourcePage() {
        this.context.currentResource(this.currentResource);
        MockSlingHttpServletRequest request = this.context.request();
        SlingBindingsModel model = (SlingBindingsModel)request.adaptTo(SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)this.currentPage, (Object)model.getCurrentPage());
        Assert.assertEquals((Object)this.currentResource, (Object)model.getResource());
        Assert.assertEquals((Object)this.currentPage, (Object)model.getResourcePage());
        Page page2 = this.context.create().page("/content/testPage2");
        Resource resourcePage2 = this.context.create().resource(page2.getContentResource().getPath() + "/testResource", new Object[]{"sling:resourceType", COMPONENT_RESOURCE_TYPE});
        ModelFactory modelFactory = (ModelFactory)this.context.getService(ModelFactory.class);
        SlingBindingsModel model2 = (SlingBindingsModel)modelFactory.getModelFromWrappedRequest((SlingHttpServletRequest)request, resourcePage2, SlingBindingsModel.class);
        Assert.assertNotNull((Object)model2);
        Assert.assertEquals((Object)this.currentPage.getPath(), (Object)model2.getCurrentPage().getPath());
        Assert.assertEquals((Object)resourcePage2.getPath(), (Object)model2.getResource().getPath());
        Assert.assertEquals((Object)page2.getPath(), (Object)model2.getResourcePage().getPath());
    }

    @Test
    public void testBindings_EditMode() {
        WCMMode.EDIT.toRequest((ServletRequest)this.context.request());
        this.context.currentResource(this.currentResource);
        SlingBindingsModel model = (SlingBindingsModel)this.context.request().adaptTo(SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getResolver());
        Assert.assertNotNull((Object)model.getResource());
        Assert.assertNotNull((Object)model.getRequest());
        Assert.assertNotNull((Object)model.getResponse());
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK || this.context.resourceResolverType() == ResourceResolverType.RESOURCEPROVIDER_MOCK) {
            Assert.assertNull((Object)model.getCurrentNode());
            Assert.assertNull((Object)model.getcurrentSession());
        } else {
            Assert.assertNotNull((Object)model.getCurrentNode());
            Assert.assertNotNull((Object)model.getcurrentSession());
        }
        Assert.assertNotNull((Object)model.getComponentContext());
        Assert.assertNotNull((Object)model.getEditContext());
        Assert.assertNotNull((Object)model.getProperties());
        Assert.assertNotNull((Object)model.getPageManager());
        Assert.assertNotNull((Object)model.getCurrentPage());
        Assert.assertNotNull((Object)model.getResourcePage());
        Assert.assertNotNull((Object)model.getPageProperties());
        Assert.assertNotNull((Object)model.getComponent());
        Assert.assertNotNull((Object)model.getDesigner());
        Assert.assertNotNull((Object)model.getCurrentDesign());
        Assert.assertNotNull((Object)model.getResourceDesign());
        Assert.assertNotNull((Object)model.getCurrentStyle());
    }

    @Test
    public void testBindingsModelFactory() throws Exception {
        this.context.currentResource(this.currentResource);
        ModelFactory modelFactory = (ModelFactory)this.context.getService(ModelFactory.class);
        SlingBindingsModel model = (SlingBindingsModel)modelFactory.getModelFromWrappedRequest((SlingHttpServletRequest)this.context.request(), this.context.currentResource(), SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getResolver());
        Assert.assertNotNull((Object)model.getResource());
        Assert.assertNotNull((Object)model.getRequest());
        Assert.assertNotNull((Object)model.getResponse());
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK || this.context.resourceResolverType() == ResourceResolverType.RESOURCEPROVIDER_MOCK) {
            Assert.assertNull((Object)model.getCurrentNode());
            Assert.assertNull((Object)model.getcurrentSession());
        } else {
            Assert.assertNotNull((Object)model.getCurrentNode());
            Assert.assertNotNull((Object)model.getcurrentSession());
        }
        Assert.assertNotNull((Object)model.getComponentContext());
        Assert.assertNull((Object)model.getEditContext());
        Assert.assertNotNull((Object)model.getProperties());
        Assert.assertNotNull((Object)model.getPageManager());
        Assert.assertNotNull((Object)model.getCurrentPage());
        Assert.assertNotNull((Object)model.getResourcePage());
        Assert.assertNotNull((Object)model.getPageProperties());
        Assert.assertNotNull((Object)model.getComponent());
        Assert.assertNotNull((Object)model.getDesigner());
        Assert.assertNotNull((Object)model.getCurrentDesign());
        Assert.assertNotNull((Object)model.getResourceDesign());
        Assert.assertNotNull((Object)model.getCurrentStyle());
    }

    @Test
    public void testContentPolicy() {
        this.context.contentPolicyMapping(COMPONENT_RESOURCE_TYPE, new Object[]{"policyProp1", "value1"});
        this.context.currentResource(this.currentResource);
        SlingBindingsModel model = (SlingBindingsModel)this.context.request().adaptTo(SlingBindingsModel.class);
        Assert.assertEquals((Object)"value1", (Object)model.getCurrentStyle().get("policyProp1", String.class));
    }

    @Test
    public void testContentPolicy_SlingModelDelegation() {
        this.context.contentPolicyMapping(COMPONENT_RESOURCE_TYPE, new Object[]{"policyProp1", "value1"});
        this.context.currentResource((Resource)new ResourceTypeForcingResourceWrapper(this.currentResource, COMPONENT_RESOURCE_SUPER_TYPE));
        SlingBindingsModel model = (SlingBindingsModel)this.context.request().adaptTo(SlingBindingsModel.class);
        Assert.assertEquals((Object)"value1", (Object)model.getCurrentStyle().get("policyProp1", String.class));
    }
}

