/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import io.wcm.testing.mock.aem.context.OsgiServiceWithModelFactory;
import io.wcm.testing.mock.aem.junit.AemContext;
import io.wcm.testing.mock.aem.modelsautoreg.ClasspathRegisteredModel;
import io.wcm.testing.mock.aem.modelsautoreg.ModelWithModelFactory;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SlingModelsRegistrationTest {
    @Rule
    public AemContext context = new AemContext(new ResourceResolverType[0]);

    @Test
    public void testSlingModelClasspathRegistered() {
        this.context.request().setAttribute("prop1", (Object)"myValue");
        ClasspathRegisteredModel model = (ClasspathRegisteredModel)this.context.request().adaptTo(ClasspathRegisteredModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"myValue", (Object)model.getProp1());
    }

    @Test
    public void testCreationViaModelFactory() {
        this.context.request().setAttribute("prop1", (Object)"myValue");
        ClasspathRegisteredModel model = (ClasspathRegisteredModel)((ModelFactory)this.context.getService(ModelFactory.class)).createModel((Object)this.context.request(), ClasspathRegisteredModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"myValue", (Object)model.getProp1());
    }

    @Test
    public void testModelWithModelFactoryReference() {
        ModelWithModelFactory model = (ModelWithModelFactory)this.context.request().adaptTo(ModelWithModelFactory.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getModelFactory());
    }

    @Test
    public void testOsgiServiceWithModelFactoryReference() {
        OsgiServiceWithModelFactory service = (OsgiServiceWithModelFactory)this.context.registerInjectActivateService(new OsgiServiceWithModelFactory());
        Assert.assertNotNull((Object)service.getModelFactory());
    }
}

