/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.DamEvent;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.UIHelper;
import com.day.cq.wcm.foundation.WCMRenditionPicker;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.dam.MockAssetManagerTest;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.service.event.EventHandler;

public class MockAssetTest {
    private static final byte[] BINARY_DATA = new byte[]{1, 2, 3, 4, 5};
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Asset asset;
    private MockAssetManagerTest.DamEventHandler damEventHandler;

    @Before
    public void setUp() throws Exception {
        this.context.load().json("/json-import-samples/dam.json", "/content/dam/sample");
        Resource resource = this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg");
        this.asset = (Asset)resource.adaptTo(Asset.class);
        this.damEventHandler = (MockAssetManagerTest.DamEventHandler)this.context.registerService(EventHandler.class, new MockAssetManagerTest.DamEventHandler());
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((Object)"scott_reynolds.jpg", (Object)this.asset.getName());
        Assert.assertEquals((Object)"/content/dam/sample/portraits/scott_reynolds.jpg", (Object)this.asset.getPath());
        Assert.assertEquals((long)1368001317000L, (long)this.asset.getLastModified());
        Assert.assertEquals((Object)"admin", (Object)this.asset.getModifier());
        Assert.assertEquals((Object)"image/jpeg", (Object)this.asset.getMimeType());
        Assert.assertNotNull((Object)this.asset.hashCode());
    }

    @Test
    public void testMetadata() {
        Assert.assertEquals((Object)807L, this.asset.getMetadata().get("tiff:ImageWidth"));
        Assert.assertEquals((Object)595L, (Object)this.asset.getMetadata("tiff:ImageLength"));
        Assert.assertEquals((Object)"Scott Reynolds", (Object)this.asset.getMetadataValue("dc:title"));
        Assert.assertEquals((Object)"Scott Reynolds", (Object)this.asset.getMetadataValueFromJcr("dc:title"));
    }

    @Test
    public void testRenditions() {
        List renditions = this.asset.getRenditions();
        Assert.assertEquals((long)4L, (long)renditions.size());
        Assert.assertTrue((boolean)this.hasRendition(renditions, "cq5dam.thumbnail.48.48.png"));
        Assert.assertEquals((Object)"original", (Object)this.asset.getOriginal().getName());
        Assert.assertEquals((Object)"original", (Object)this.asset.getRendition((RenditionPicker)new WCMRenditionPicker()).getName());
    }

    private boolean hasRendition(List<Rendition> renditions, String renditionName) {
        for (Rendition rendition : renditions) {
            if (!StringUtils.equals((CharSequence)rendition.getName(), (CharSequence)renditionName)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testEquals() throws Exception {
        Asset asset1 = (Asset)this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg").adaptTo(Asset.class);
        Asset asset2 = (Asset)this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg").adaptTo(Asset.class);
        Assert.assertTrue((boolean)asset1.equals(asset2));
    }

    private void doTestAddRemoveRendition(String renditionName) {
        ByteArrayInputStream is = new ByteArrayInputStream(BINARY_DATA);
        Rendition rendition = this.asset.addRendition(renditionName, (InputStream)is, "application/octet-stream");
        Assert.assertNotNull((Object)rendition);
        Assert.assertNotNull((Object)this.asset.getRendition(renditionName));
        Resource resource = this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/" + renditionName);
        Assert.assertNotNull((Object)resource);
        Optional<DamEvent> damEvent = this.damEventHandler.getLastEvent();
        Assert.assertTrue((boolean)damEvent.isPresent());
        Assert.assertEquals((Object)DamEvent.Type.RENDITION_UPDATED, (Object)damEvent.get().getType());
        Assert.assertEquals((Object)this.asset.getPath(), (Object)damEvent.get().getAssetPath());
        Assert.assertEquals((Object)rendition.getPath(), (Object)damEvent.get().getAdditionalInfo());
        this.asset.removeRendition(renditionName);
        Assert.assertNull((Object)this.asset.getRendition(renditionName));
        resource = this.context.resourceResolver().getResource("/content/dam/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/" + renditionName);
        Assert.assertNull((Object)resource);
        damEvent = this.damEventHandler.getLastEvent();
        Assert.assertTrue((boolean)damEvent.isPresent());
        Assert.assertEquals((Object)DamEvent.Type.RENDITION_REMOVED, (Object)damEvent.get().getType());
        Assert.assertEquals((Object)this.asset.getPath(), (Object)damEvent.get().getAssetPath());
        Assert.assertEquals((Object)rendition.getPath(), (Object)damEvent.get().getAdditionalInfo());
    }

    @Test
    public void testAddRemoveRendition() throws Exception {
        this.doTestAddRemoveRendition("test.bin");
    }

    @Test
    public void testRenditionListMutable() throws Exception {
        UIHelper.getBestfitRendition((Asset)this.asset, (int)100);
    }

    @Test
    public void testBatchMode() throws Exception {
        if (this.context.resourceResolverType() == ResourceResolverType.JCR_MOCK) {
            return;
        }
        this.asset.setBatchMode(true);
        Assert.assertTrue((boolean)this.asset.isBatchMode());
        this.doTestAddRemoveRendition("testwithbatchmode.bin");
        Assert.assertTrue((boolean)this.context.resourceResolver().hasChanges());
        this.context.resourceResolver().revert();
        this.asset.setBatchMode(false);
        Assert.assertFalse((boolean)this.asset.isBatchMode());
        this.doTestAddRemoveRendition("testwithoutbatchmode.bin");
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testGetID() {
        if (this.context.resourceResolverType() == ResourceResolverType.JCR_OAK) {
            Assert.assertNotNull((Object)this.asset.getID());
        } else {
            Assert.assertEquals((Object)"442d55b6-d534-4faf-9394-c9c20d095985", (Object)this.asset.getID());
        }
    }

    @Test
    public void testRemoveNonExistingRendition() {
        this.asset.removeRendition("non-existing");
    }
}

