/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.image.Layer;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.io.File;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ContentLoaderFolderTest {
    private static final File FOLDER_CONTENT_SAMPLE = new File("src/test/resources/folder-content-sample");
    private static final String STRUCTURE_ELEMENT_TEMPLATE_PATH = "/apps/myproject1/templates/structureElement";
    private static final String SAMPLE_COMPONENT_PATH = "/apps/myproject1/components/customcarousel";
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Test
    public void testAppsJSON() {
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK) {
            return;
        }
        this.context.load().folderJson(new File(FOLDER_CONTENT_SAMPLE, "apps-json"), "/apps/myproject1");
        Resource templateResource = this.context.resourceResolver().getResource(STRUCTURE_ELEMENT_TEMPLATE_PATH);
        Assert.assertNotNull((Object)templateResource);
        Assert.assertEquals((Object)"myproject1 Structure Element", (Object)templateResource.getValueMap().get((Object)"jcr:title"));
        Template template = (Template)templateResource.adaptTo(Template.class);
        Assert.assertEquals((Object)"myproject1 Structure Element", (Object)template.getTitle());
        ComponentManager componentManager = (ComponentManager)this.context.resourceResolver().adaptTo(ComponentManager.class);
        Component component = componentManager.getComponent(SAMPLE_COMPONENT_PATH);
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)"Carousel (Custom)", (Object)component.getTitle());
    }

    @Test
    public void testAppsFileVault() {
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK) {
            return;
        }
        this.context.load().folderFileVaultXml(new File(FOLDER_CONTENT_SAMPLE, "apps-filevault"), "/apps/myproject1");
        Resource templateResource = this.context.resourceResolver().getResource(STRUCTURE_ELEMENT_TEMPLATE_PATH);
        Assert.assertNotNull((Object)templateResource);
        Assert.assertEquals((Object)"myproject1 Structure Element", (Object)templateResource.getValueMap().get((Object)"jcr:title"));
        Template template = (Template)templateResource.adaptTo(Template.class);
        Assert.assertEquals((Object)"myproject1 Structure Element", (Object)template.getTitle());
        ComponentManager componentManager = (ComponentManager)this.context.resourceResolver().adaptTo(ComponentManager.class);
        Component component = componentManager.getComponent(SAMPLE_COMPONENT_PATH);
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)"Carousel (Custom)", (Object)component.getTitle());
    }

    @Test
    public void testContentConfFileVault() {
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK) {
            return;
        }
        this.context.load().folderFileVaultXml(new File(FOLDER_CONTENT_SAMPLE, "conf-filevault"), "/conf/myproject1");
        this.context.load().folderFileVaultXml(new File(FOLDER_CONTENT_SAMPLE, "content-filevault"), "/content/myproject1");
        Page testPage = this.context.pageManager().getPage("/content/myproject1/test");
        Assert.assertNotNull((Object)testPage);
        Assert.assertEquals((Object)"Test", (Object)testPage.getTitle());
        Template template = testPage.getTemplate();
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"myproject1 Content", (Object)template.getTitle());
    }

    @Test
    public void testAsset() {
        if (this.context.resourceResolverType() == ResourceResolverType.RESOURCERESOLVER_MOCK) {
            return;
        }
        this.context.load().folderFileVaultXml(new File(FOLDER_CONTENT_SAMPLE, "content-filevault"), "/content/dam/myproject1");
        Resource assetResource = this.context.resourceResolver().getResource("/content/dam/myproject1/sample.jpg");
        Assert.assertNotNull((Object)assetResource);
        Asset asset = (Asset)assetResource.adaptTo(Asset.class);
        Assert.assertEquals((Object)"sample.jpg", (Object)asset.getName());
        Layer layer = (Layer)asset.getOriginal().adaptTo(Layer.class);
        Assert.assertNotNull((Object)layer);
        Assert.assertEquals((long)100L, (long)layer.getWidth());
        Assert.assertEquals((long)50L, (long)layer.getHeight());
    }
}

