/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockComponentManagerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private ComponentManager underTest;

    @Before
    public void setUp() {
        this.context.create().resource("/apps/app1/components/c1", new Object[]{"jcr:title", "myTitle", "jcr:description", "myDescription", "componentGroup", "myGroup", "cq:noDecoration", true});
        this.context.create().resource("/apps/app1/components/c1/cq:htmlTag", new Object[]{"cq:tagName", "myTag", "prop2", "myValue2"});
        this.context.create().resource("/libs/app1/components/c2");
        this.context.create().resource("/apps/app1/components/c2");
        this.context.create().resource("/libs/app1/components/c3");
        this.context.create().resource("/apps/app1/components/c4", new Object[]{"sling:resourceSuperType", "app1/components/c1"});
        this.context.create().resource("/content/myresource", new Object[]{"sling:resourceType", "/apps/app1/components/c1"});
        this.underTest = (ComponentManager)this.context.resourceResolver().adaptTo(ComponentManager.class);
    }

    @Test
    public void testGetComponent() {
        Component component = this.underTest.getComponent("/apps/app1/components/c1");
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)component.getPath());
        Assert.assertEquals((Object)"c1", (Object)component.getName());
        Assert.assertEquals((Object)"myTitle", (Object)component.getTitle());
        Assert.assertEquals((Object)"myDescription", (Object)component.getDescription());
        Assert.assertEquals((Object)"myTitle", (Object)component.getProperties().get("jcr:title", String.class));
        Assert.assertEquals((Object)"app1/components/c1", (Object)component.getResourceType());
        Assert.assertTrue((boolean)component.isAccessible());
        Assert.assertNotNull((Object)component.adaptTo(Resource.class));
        Assert.assertEquals((Object)"myGroup", (Object)component.getComponentGroup());
        Assert.assertTrue((boolean)component.noDecoration());
        Assert.assertEquals((Object)"myTag", component.getHtmlTagAttributes().get("cq:tagName"));
        Assert.assertEquals((Object)"myValue2", component.getHtmlTagAttributes().get("prop2"));
        Assert.assertNull((Object)component.getSuperComponent());
        Resource localResource = component.getLocalResource("cq:htmlTag");
        Assert.assertEquals((Object)"myValue2", (Object)localResource.getValueMap().get("prop2", String.class));
    }

    @Test
    public void testSuperComponent() {
        Component component = this.underTest.getComponent("/apps/app1/components/c4");
        Component superComponent = component.getSuperComponent();
        Assert.assertNotNull((Object)superComponent);
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)superComponent.getPath());
    }

    @Test
    public void testInvalidComponent() {
        Component component = this.underTest.getComponent("/invalidPath");
        Assert.assertNull((Object)component);
    }

    @Test
    public void testGetComponentWithSearchPath() {
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)this.underTest.getComponent("app1/components/c1").getPath());
        Assert.assertEquals((Object)"/apps/app1/components/c2", (Object)this.underTest.getComponent("app1/components/c2").getPath());
        Assert.assertEquals((Object)"/libs/app1/components/c3", (Object)this.underTest.getComponent("app1/components/c3").getPath());
    }

    @Test
    public void testGetComponentOfResource() {
        Resource resource = this.context.resourceResolver().getResource("/content/myresource");
        Component component = this.underTest.getComponentOfResource(resource);
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)"/apps/app1/components/c1", (Object)component.getPath());
    }

    @Test
    public void testGetComponentOfResourceWithoutResourceType() {
        this.context.create().resource("/content/myresourceWithoutResourceType");
        Resource resource = this.context.resourceResolver().getResource("/content/myresourceWithoutResourceType");
        Component component = this.underTest.getComponentOfResource(resource);
        Assert.assertNull((Object)component);
    }

    @Test
    public void testPropertyFromComponentWithChildResourceDoesNotWork() {
        this.context.create().resource("/apps/app1/components/c1/child1", new Object[]{"prop1", "value1"});
        Component component = this.underTest.getComponent("/apps/app1/components/c1");
        Assert.assertNull((Object)component.getProperties().get((Object)"child1/prop1"));
    }
}

