/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.VariationTemplate;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MockContentFragmentTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Test
    public void testContentFragmentStructure() throws Exception {
        String assetPath = this.context.uniqueRoot().dam() + "/cfStructure";
        ContentFragment cf = this.context.create().contentFragmentStructured(assetPath, new Object[]{"param1", "value1", "param2", 123, "param3", true, "param4", new String[]{"v1", "v2"}});
        Assert.assertNotNull((Object)cf);
        cf.setTitle("myTitle");
        cf.setDescription("myDesc");
        cf.setMetaData("meta1", (Object)"value1");
        Assert.assertEquals((Object)"cfStructure", (Object)cf.getName());
        Assert.assertEquals((Object)"myTitle", (Object)cf.getTitle());
        Assert.assertEquals((Object)"myDesc", (Object)cf.getDescription());
        Assert.assertEquals((Object)"value1", cf.getMetaData().get("meta1"));
        Assert.assertTrue((boolean)cf.getElements().hasNext());
        Assert.assertTrue((boolean)cf.hasElement("param1"));
        Assert.assertEquals((Object)"value1", (Object)cf.getElement("param1").getContent());
        Assert.assertEquals((Object)"123", (Object)cf.getElement("param2").getContent());
        Assert.assertEquals((Object)"true", (Object)cf.getElement("param3").getContent());
        Assert.assertEquals((Object)"v1\nv2", (Object)cf.getElement("param4").getContent());
        ContentElement param1 = cf.getElement("param1");
        param1.setContent("new_value", null);
        Assert.assertEquals((Object)"new_value", (Object)param1.getContent());
        VariationTemplate varTemplate = cf.createVariation("v1", "V1", "desc1");
        ContentVariation var = param1.createVariation(varTemplate);
        Assert.assertEquals((Object)"v1", (Object)var.getName());
        Assert.assertEquals((Object)"V1", (Object)var.getTitle());
        Assert.assertEquals((Object)"desc1", (Object)var.getDescription());
        var.setContent("var_value", null);
        Assert.assertEquals((Object)"var_value", (Object)var.getContent());
        Assert.assertEquals((long)1L, (long)IteratorUtils.toList((Iterator)cf.listAllVariations()).size());
        Assert.assertEquals((long)1L, (long)IteratorUtils.toList((Iterator)param1.getVariations()).size());
        var = param1.getVariation("v1");
        Assert.assertEquals((Object)"v1", (Object)var.getName());
        param1.removeVariation(var);
        varTemplate = cf.createVariation("v2", null, null);
        var = param1.createVariation(varTemplate);
        Assert.assertEquals((Object)"v2", (Object)var.getName());
        Assert.assertEquals((Object)"v2", (Object)var.getTitle());
        Assert.assertEquals((Object)"", (Object)var.getDescription());
    }

    @Test
    public void testContentFragmentText() throws Exception {
        String assetPath = this.context.uniqueRoot().dam() + "/cfText";
        ContentFragment cf = this.context.create().contentFragmentText(assetPath, "<p>Text</p>", "text/html");
        Assert.assertNotNull((Object)cf);
        cf.setTitle("myTitle");
        cf.setDescription("myDesc");
        cf.setMetaData("meta1", (Object)"value1");
        Assert.assertEquals((Object)"cfText", (Object)cf.getName());
        Assert.assertEquals((Object)"myTitle", (Object)cf.getTitle());
        Assert.assertEquals((Object)"myDesc", (Object)cf.getDescription());
        Assert.assertEquals((Object)"value1", cf.getMetaData().get("meta1"));
        Assert.assertEquals((Object)"text/html", cf.getMetaData().get("dc:format"));
        Assert.assertTrue((boolean)cf.getElements().hasNext());
        Assert.assertTrue((boolean)cf.hasElement("main"));
        ContentElement contentElementEmptyParam = cf.getElement("");
        Assert.assertEquals((Object)"<p>Text</p>", (Object)contentElementEmptyParam.getContent());
        Assert.assertEquals((Object)"text/html", (Object)contentElementEmptyParam.getContentType());
        ContentElement contentElementNullParam = cf.getElement(null);
        Assert.assertEquals((Object)"<p>Text</p>", (Object)contentElementNullParam.getContent());
        Assert.assertEquals((Object)"text/html", (Object)contentElementNullParam.getContentType());
        ContentElement contentElement = cf.getElement("main");
        Assert.assertEquals((Object)"<p>Text</p>", (Object)contentElement.getContent());
        Assert.assertEquals((Object)"text/html", (Object)contentElement.getContentType());
        contentElement.setContent("Text", "text/plain");
        Assert.assertEquals((Object)"Text", (Object)contentElement.getContent());
        Assert.assertEquals((Object)"text/plain", (Object)contentElement.getContentType());
        VariationTemplate varTemplate = cf.createVariation("v1", "V1", "desc1");
        ContentVariation var = contentElement.createVariation(varTemplate);
        Assert.assertEquals((Object)"v1", (Object)var.getName());
        Assert.assertEquals((Object)"V1", (Object)var.getTitle());
        Assert.assertEquals((Object)"desc1", (Object)var.getDescription());
        var.setContent("Var-Text", "text/plain");
        Assert.assertEquals((Object)"Var-Text", (Object)var.getContent());
        Assert.assertEquals((Object)"text/plain", (Object)var.getContentType());
        Assert.assertEquals((long)1L, (long)IteratorUtils.toList((Iterator)cf.listAllVariations()).size());
        Assert.assertEquals((long)1L, (long)IteratorUtils.toList((Iterator)contentElement.getVariations()).size());
        var = contentElement.getVariation("v1");
        Assert.assertEquals((Object)"v1", (Object)var.getName());
        contentElement.removeVariation(var);
    }
}

