/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import io.wcm.testing.mock.aem.MockContentPolicy;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import io.wcm.testing.mock.aem.models.policy.ContentPolicyTestModel;
import java.util.Calendar;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MockContentPolicyTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Test
    public void testProperties() {
        Calendar timestamp = Calendar.getInstance();
        Resource resource = this.context.create().resource("/content/test", new Object[]{"jcr:lastModified", timestamp, "jcr:lastModifiedBy", "user1", "jcr:title", "title1", "jcr:description", "description1", "prop1", "value1"});
        MockContentPolicy underTest = new MockContentPolicy(resource);
        Assert.assertEquals((Object)"value1", (Object)underTest.getProperties().get("prop1", String.class));
        Assert.assertEquals((long)timestamp.getTimeInMillis(), (long)underTest.getLastModified().getTimeInMillis());
        Assert.assertEquals((Object)"user1", (Object)underTest.getLastModifiedBy());
        Assert.assertEquals((Object)"title1", (Object)underTest.getTitle());
        Assert.assertEquals((Object)"description1", (Object)underTest.getDescription());
        Assert.assertEquals((Object)"test", (Object)underTest.getName());
        Assert.assertEquals((Object)resource.getPath(), (Object)underTest.getPath());
        Assert.assertNull((Object)underTest.adaptTo(Object.class));
    }

    @Test
    public void testEmpty() {
        Resource resource = this.context.create().resource("/content/test");
        MockContentPolicy underTest = new MockContentPolicy(resource);
        Assert.assertNull((Object)underTest.getProperties().get("prop1", String.class));
        Assert.assertNull((Object)underTest.getLastModified());
        Assert.assertNull((Object)underTest.getLastModifiedBy());
    }

    @Test
    public void testAdaptToCustomSlingModel() {
        this.context.addModelsForClasses(new Class[]{ContentPolicyTestModel.class});
        Resource resource = this.context.create().resource("/content/test", new Object[]{"prop1", "value1", "prop2", true});
        MockContentPolicy policy = new MockContentPolicy(resource);
        ContentPolicyTestModel underTest = (ContentPolicyTestModel)policy.adaptTo(ContentPolicyTestModel.class);
        Assert.assertNotNull((Object)underTest);
        Assert.assertEquals((Object)"value1", (Object)underTest.getProp1());
        Assert.assertEquals((Object)true, (Object)underTest.getProp2());
    }
}

