/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.JSONItem;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.DialogMode;
import com.day.cq.wcm.api.components.DropTarget;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.EditLayout;
import com.day.cq.wcm.api.components.InplaceEditingConfig;
import com.day.cq.wcm.commons.WCMUtils;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import javax.jcr.Node;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class MockEditConfigTest {
    private static final String COMPONENT_RESOURCE_TYPE = "/apps/test/components/component1";
    private static final String PAGE_PATH = "/content/page1";
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Page page;
    private Resource resource;
    private Resource inplaceEditingConfig;
    private ComponentContext componentContext;
    private EditConfig underTest;

    @Before
    public void setUp() {
        WCMMode.EDIT.toRequest((ServletRequest)this.context.request());
        this.context.create().resource(COMPONENT_RESOURCE_TYPE, new Object[]{"jcr:primaryType", "cq:Component"});
        this.page = this.context.create().page(PAGE_PATH);
        this.resource = this.context.create().resource(this.page.getContentResource().getPath() + "/comp1", new Object[]{"sling:resourceType", COMPONENT_RESOURCE_TYPE});
        this.inplaceEditingConfig = this.context.create().resource("/apps/test/components/component1/cq:inplaceEditing", new Object[]{"jcr:primaryType", "cq:InplaceEditingConfig", "active", true, "editorType", "text"});
        this.context.currentPage(this.page);
        this.context.currentResource(this.resource);
        this.componentContext = WCMUtils.getComponentContext((ServletRequest)this.context.request());
        this.underTest = this.componentContext.getEditContext().getEditConfig();
        Assert.assertNotNull((Object)this.underTest);
    }

    @Test
    public void testGetLayout() {
        Assert.assertEquals((Object)EditLayout.AUTO, (Object)this.underTest.getLayout());
        this.underTest.setLayout(EditLayout.EDITBAR);
        Assert.assertEquals((Object)EditLayout.EDITBAR, (Object)this.underTest.getLayout());
    }

    @Test
    public void testGetDialogMode() {
        Assert.assertEquals((Object)DialogMode.AUTO, (Object)this.underTest.getDialogMode());
        this.underTest.setDialogMode(DialogMode.FLOATING);
        Assert.assertEquals((Object)DialogMode.FLOATING, (Object)this.underTest.getDialogMode());
    }

    @Test
    public void testGetInplaceEditingConfig() throws Exception {
        Assert.assertNull((Object)this.underTest.getInplaceEditingConfig());
        Node node = (Node)this.inplaceEditingConfig.adaptTo(Node.class);
        if (node == null) {
            return;
        }
        InplaceEditingConfig config = new InplaceEditingConfig(node);
        this.underTest.setInplaceEditingConfig(config);
        Assert.assertSame((Object)config, (Object)this.underTest.getInplaceEditingConfig());
    }

    @Test
    public void testGetInsertBehavior() {
        Assert.assertNull((Object)this.underTest.getInsertBehavior());
        this.underTest.setInsertBehavior("test");
        Assert.assertEquals((Object)"test", (Object)this.underTest.getInsertBehavior());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertFalse((boolean)this.underTest.isEmpty());
        this.underTest.setEmpty(true);
        Assert.assertTrue((boolean)this.underTest.isEmpty());
    }

    @Test
    public void testGetEmptyText() {
        Assert.assertNull((Object)this.underTest.getEmptyText());
        this.underTest.setEmptyText("test");
        Assert.assertEquals((Object)"test", (Object)this.underTest.getEmptyText());
    }

    @Test
    public void testIsOrderable() {
        Assert.assertNull((Object)this.underTest.isOrderable());
        this.underTest.setOrderable(Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.underTest.isOrderable());
    }

    @Test
    public void testIsDeepCancel() {
        Assert.assertNull((Object)this.underTest.isDeepCancel());
        this.underTest.setDeepCancel(Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.underTest.isDeepCancel());
    }

    @Test
    public void testGetLiveRelationship() {
        Assert.assertNull((Object)this.underTest.getLiveRelationship());
        JSONItem jsonItem = (JSONItem)Mockito.mock(JSONItem.class);
        this.underTest.setLiveRelationship(jsonItem);
        Assert.assertSame((Object)jsonItem, (Object)this.underTest.getLiveRelationship());
    }

    @Test
    public void testGetDropTargets() {
        Assert.assertTrue((boolean)this.underTest.getDropTargets().isEmpty());
        DropTarget dropTarget = (DropTarget)Mockito.mock(DropTarget.class);
        this.underTest.getDropTargets().put("target1", dropTarget);
        Assert.assertSame((Object)dropTarget, this.underTest.getDropTargets().get("target1"));
    }
}

