/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Externalizer;
import io.wcm.testing.mock.aem.MockExternalizer;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockExternalizerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private ResourceResolver resolver;
    private MockExternalizer underTest;

    @Before
    public void setUp() {
        this.resolver = this.context.resourceResolver();
        this.underTest = (MockExternalizer)this.context.getService(Externalizer.class);
        Assert.assertNotNull((Object)this.underTest);
    }

    @Test
    public void testExternalLink() {
        Assert.assertEquals((Object)"http://localhost:4502/mypath", (Object)this.underTest.externalLink(this.resolver, "local", "/mypath"));
        Assert.assertEquals((Object)"http://localhost:4502/mypath", (Object)this.underTest.externalLink(this.resolver, "author", "/mypath"));
        Assert.assertEquals((Object)"http://localhost:4503/mypath", (Object)this.underTest.externalLink(this.resolver, "publish", "/mypath"));
        Assert.assertEquals((Object)"https://localhost:4502/mypath", (Object)this.underTest.externalLink(this.resolver, "local", "https", "/mypath"));
        Assert.assertEquals((Object)"https://localhost:4502/mypath", (Object)this.underTest.externalLink(this.resolver, "author", "https", "/mypath"));
        Assert.assertEquals((Object)"https://localhost:4503/mypath", (Object)this.underTest.externalLink(this.resolver, "publish", "https", "/mypath"));
    }

    @Test
    public void testExternalLink_CustomMapping() {
        this.underTest.setMapping("local", "http://lh:4502");
        this.underTest.setMapping("author", "https://author.sample.com");
        this.underTest.setMapping("publish", "https://www.sample.com");
        this.underTest.setMapping("custom", "http://custom.sample.com");
        Assert.assertEquals((Object)"http://lh:4502/mypath", (Object)this.underTest.externalLink(this.resolver, "local", "/mypath"));
        Assert.assertEquals((Object)"https://author.sample.com/mypath", (Object)this.underTest.externalLink(this.resolver, "author", "/mypath"));
        Assert.assertEquals((Object)"https://www.sample.com/mypath", (Object)this.underTest.externalLink(this.resolver, "publish", "/mypath"));
        Assert.assertEquals((Object)"http://custom.sample.com/mypath", (Object)this.underTest.externalLink(this.resolver, "custom", "/mypath"));
        Assert.assertEquals((Object)"https://lh:4502/mypath", (Object)this.underTest.externalLink(this.resolver, "local", "https", "/mypath"));
        Assert.assertEquals((Object)"https://author.sample.com/mypath", (Object)this.underTest.externalLink(this.resolver, "author", "https", "/mypath"));
        Assert.assertEquals((Object)"https://www.sample.com/mypath", (Object)this.underTest.externalLink(this.resolver, "publish", "https", "/mypath"));
        Assert.assertEquals((Object)"https://custom.sample.com/mypath", (Object)this.underTest.externalLink(this.resolver, "custom", "https", "/mypath"));
    }

    @Test
    public void testExternalLink_NonExisingMapping() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.underTest.externalLink(this.resolver, "non-existing", "/mypath"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.underTest.externalLink(this.resolver, "non-existing", "https", "/mypath"));
    }

    @Test
    public void testAuthorLink() {
        Assert.assertEquals((Object)"http://localhost:4502/mypath", (Object)this.underTest.authorLink(this.resolver, "/mypath"));
        Assert.assertEquals((Object)"https://localhost:4502/mypath", (Object)this.underTest.authorLink(this.resolver, "https", "/mypath"));
    }

    @Test
    public void testPublishLink() {
        Assert.assertEquals((Object)"http://localhost:4503/mypath", (Object)this.underTest.publishLink(this.resolver, "/mypath"));
        Assert.assertEquals((Object)"https://localhost:4503/mypath", (Object)this.underTest.publishLink(this.resolver, "https", "/mypath"));
    }

    @Test
    public void testAbsoluteLink() {
        Assert.assertEquals((Object)"http://localhost:4502/mypath", (Object)this.underTest.absoluteLink(this.resolver, "http", "/mypath"));
        Assert.assertEquals((Object)"https://localhost:80/mypath", (Object)this.underTest.absoluteLink((SlingHttpServletRequest)this.context.request(), "https", "/mypath"));
        Assert.assertEquals((Object)"http://localhost:4502/mypath", (Object)this.underTest.absoluteLink("http", "/mypath"));
    }

    @Test
    public void testRelativeLink() {
        Assert.assertEquals((Object)"/mypath", (Object)this.underTest.relativeLink((SlingHttpServletRequest)this.context.request(), "/mypath"));
    }
}

