/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.tagging.JcrTagManagerFactory;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockJcrTagManagerFactoryTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private JcrTagManagerFactory underTest;

    @Before
    public void setUp() {
        this.context.create().tag("test:test-tag");
        this.underTest = (JcrTagManagerFactory)this.context.getService(JcrTagManagerFactory.class);
    }

    @Test
    public void testGetTagManagerFromResourceResolver() {
        TagManager tagManager = this.underTest.getTagManager(this.context.resourceResolver());
        Assert.assertNotNull((Object)tagManager);
        Tag tag = tagManager.resolve("test:test-tag");
        Assert.assertNotNull((Object)tag);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTagManagerFromResourceResolverWithNull() {
        this.underTest.getTagManager((ResourceResolver)null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetTagManagerFromSession() {
        this.underTest.getTagManager((Session)null);
    }
}

