/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.image.Layer;
import io.wcm.testing.mock.aem.MockLayerAdapterFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.AdapterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MockLayerAdapterFactoryTest {
    @Mock
    Adaptable adaptable;
    private AdapterFactory underTest;

    @Before
    public void setUp() {
        this.underTest = new MockLayerAdapterFactory();
    }

    @Test
    public void testImage() {
        InputStream is = this.getClass().getResourceAsStream("/sample-image.gif");
        Mockito.when((Object)((InputStream)this.adaptable.adaptTo(InputStream.class))).thenReturn((Object)is);
        Layer layer = (Layer)this.underTest.getAdapter((Object)this.adaptable, Layer.class);
        Assert.assertNotNull((Object)layer);
        Assert.assertEquals((long)2L, (long)layer.getWidth());
        Assert.assertEquals((long)2L, (long)layer.getHeight());
    }

    @Test
    public void testInvalidInputStream() {
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{1, 2, 3});
        Mockito.when((Object)((InputStream)this.adaptable.adaptTo(InputStream.class))).thenReturn((Object)is);
        Layer layer = (Layer)this.underTest.getAdapter((Object)this.adaptable, Layer.class);
        Assert.assertNull((Object)layer);
    }

    @Test
    public void testNoInputStream() {
        Mockito.when((Object)((InputStream)this.adaptable.adaptTo(InputStream.class))).thenReturn(null);
        Layer layer = (Layer)this.underTest.getAdapter((Object)this.adaptable, Layer.class);
        Assert.assertNull((Object)layer);
    }

    @Test
    public void testNoAdaptable() {
        Layer layer = (Layer)this.underTest.getAdapter(new Object(), Layer.class);
        Assert.assertNull((Object)layer);
    }
}

