/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import io.wcm.testing.mock.aem.MockPage;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class MockPageTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private Resource mockResource = (Resource)Mockito.mock(Resource.class);
    private Page page;

    @Before
    public void setUp() throws Exception {
        this.context.load().json("/json-import-samples/content.json", "/content/sample/en");
        Resource resource = this.context.resourceResolver().getResource("/content/sample/en");
        this.page = (Page)resource.adaptTo(Page.class);
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((Object)"/content/sample/en", (Object)this.page.getPath());
        Assert.assertEquals((Object)"en", (Object)this.page.getName());
        Assert.assertEquals((Object)"English", (Object)this.page.getTitle());
        Assert.assertEquals((Object)"Sample Homepage", (Object)this.page.getPageTitle());
        Assert.assertNull((Object)this.page.getNavigationTitle());
        Assert.assertNull((Object)this.page.getDescription());
        Assert.assertEquals((long)3L, (long)this.page.getDepth());
        Assert.assertEquals((Object)false, (Object)this.page.isHideInNav());
        Assert.assertNull((Object)this.page.getVanityUrl());
        Assert.assertNotNull((Object)this.page.hashCode());
    }

    @Test
    public void testPageManager() {
        Assert.assertNotNull((Object)this.page.getPageManager());
    }

    @Test
    public void testPages() {
        Assert.assertTrue((boolean)this.page.hasChild("toolbar"));
        Assert.assertFalse((boolean)this.page.hasChild("nonExistingResource"));
        Assert.assertNull((Object)this.page.getParent());
        Page toolbarPage = this.page.getPageManager().getPage("/content/sample/en/toolbar");
        Assert.assertNotNull((Object)toolbarPage.getParent());
        Assert.assertNotNull((Object)toolbarPage.getParent(1));
        Assert.assertNull((Object)toolbarPage.getParent(2));
        Assert.assertEquals((Object)"/content/sample/en", (Object)toolbarPage.getAbsoluteParent(2).getPath());
        Assert.assertNull((Object)toolbarPage.getAbsoluteParent(1));
    }

    @Test
    public void testGetAbsoluteParent() {
        this.context.create().page("/content2");
        this.context.create().page("/content2/sample");
        this.context.create().page("/content2/sample/en");
        Page testPage = this.context.create().page("/content2/sample/en/products");
        Assert.assertEquals((Object)"/content2", (Object)testPage.getAbsoluteParent(0).getPath());
        Assert.assertEquals((Object)"/content2/sample", (Object)testPage.getAbsoluteParent(1).getPath());
        Assert.assertEquals((Object)"/content2/sample/en", (Object)testPage.getAbsoluteParent(2).getPath());
        Assert.assertEquals((Object)"/content2/sample/en/products", (Object)testPage.getAbsoluteParent(3).getPath());
        Assert.assertNull((Object)testPage.getAbsoluteParent(4));
    }

    @Test
    public void testGetAbsoluteParent_LaunchOldStructure() {
        this.context.create().page("/content/launches/launch1", "/apps/sample/templates/template1", new Object[]{"sling:resourceType", "wcm/launches/components/launch"});
        this.context.create().page("/content/launches/launch1/content2");
        this.context.create().page("/content/launches/launch1/content2/sample");
        this.context.create().page("/content/launches/launch1/content2/sample/en");
        Page testPage = this.context.create().page("/content/launches/launch1/content2/sample/en/products");
        Assert.assertEquals((Object)"/content/launches/launch1/content2", (Object)testPage.getAbsoluteParent(0).getPath());
        Assert.assertEquals((Object)"/content/launches/launch1/content2/sample", (Object)testPage.getAbsoluteParent(1).getPath());
        Assert.assertEquals((Object)"/content/launches/launch1/content2/sample/en", (Object)testPage.getAbsoluteParent(2).getPath());
        Assert.assertEquals((Object)"/content/launches/launch1/content2/sample/en/products", (Object)testPage.getAbsoluteParent(3).getPath());
        Assert.assertNull((Object)testPage.getAbsoluteParent(4));
    }

    @Test
    public void testGetAbsoluteParent_LaunchNewStructure() {
        this.context.create().page("/content/launches/2017/01/05/launch1", "/apps/sample/templates/template1", new Object[]{"sling:resourceType", "wcm/launches/components/launch"});
        this.context.create().page("/content/launches/2017/01/05/launch1/content2");
        this.context.create().page("/content/launches/2017/01/05/launch1/content2/sample");
        this.context.create().page("/content/launches/2017/01/05/launch1/content2/sample/en");
        Page testPage = this.context.create().page("/content/launches/2017/01/05/launch1/content2/sample/en/products");
        Assert.assertEquals((Object)"/content/launches/2017/01/05/launch1/content2", (Object)testPage.getAbsoluteParent(0).getPath());
        Assert.assertEquals((Object)"/content/launches/2017/01/05/launch1/content2/sample", (Object)testPage.getAbsoluteParent(1).getPath());
        Assert.assertEquals((Object)"/content/launches/2017/01/05/launch1/content2/sample/en", (Object)testPage.getAbsoluteParent(2).getPath());
        Assert.assertEquals((Object)"/content/launches/2017/01/05/launch1/content2/sample/en/products", (Object)testPage.getAbsoluteParent(3).getPath());
        Assert.assertNull((Object)testPage.getAbsoluteParent(4));
    }

    @Test
    public void testContentResource() {
        Assert.assertEquals((Object)"/content/sample/en/jcr:content", (Object)this.page.getContentResource().getPath());
        Assert.assertNotNull((Object)this.page.getContentResource("par"));
        Assert.assertNull((Object)this.page.getContentResource("nonExistingResource"));
        Assert.assertTrue((boolean)this.page.hasContent());
    }

    @Test
    public void testValidityNoOnOffTime() {
        Assert.assertNull((Object)this.page.getOnTime());
        Assert.assertNull((Object)this.page.getOffTime());
        Assert.assertTrue((boolean)this.page.isValid());
        Assert.assertEquals((long)0L, (long)this.page.timeUntilValid());
    }

    @Test
    public void testValidityInOnOffTime() throws PersistenceException {
        Calendar onTime = Calendar.getInstance();
        onTime.add(5, -1);
        Calendar offTime = Calendar.getInstance();
        offTime.add(5, 1);
        ModifiableValueMap props = (ModifiableValueMap)this.page.getContentResource().adaptTo(ModifiableValueMap.class);
        props.put((Object)"onTime", (Object)onTime);
        props.put((Object)"offTime", (Object)offTime);
        this.context.resourceResolver().commit();
        Assert.assertEquals((Object)onTime.getTime(), (Object)this.page.getOnTime().getTime());
        Assert.assertEquals((Object)offTime.getTime(), (Object)this.page.getOffTime().getTime());
        Assert.assertTrue((boolean)this.page.isValid());
        Assert.assertEquals((long)0L, (long)this.page.timeUntilValid());
    }

    @Test
    public void testValidityOnTimeInFuture() throws PersistenceException {
        Calendar onTime = Calendar.getInstance();
        onTime.add(5, 1);
        Calendar offTime = Calendar.getInstance();
        offTime.add(5, 2);
        ModifiableValueMap props = (ModifiableValueMap)this.page.getContentResource().adaptTo(ModifiableValueMap.class);
        props.put((Object)"onTime", (Object)onTime);
        props.put((Object)"offTime", (Object)offTime);
        this.context.resourceResolver().commit();
        Assert.assertEquals((Object)onTime.getTime(), (Object)this.page.getOnTime().getTime());
        Assert.assertEquals((Object)offTime.getTime(), (Object)this.page.getOffTime().getTime());
        Assert.assertFalse((boolean)this.page.isValid());
        Assert.assertTrue((this.page.timeUntilValid() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testValidityOnTimeInPast() throws PersistenceException {
        Calendar onTime = Calendar.getInstance();
        onTime.add(5, -2);
        Calendar offTime = Calendar.getInstance();
        offTime.add(5, -1);
        ModifiableValueMap props = (ModifiableValueMap)this.page.getContentResource().adaptTo(ModifiableValueMap.class);
        props.put((Object)"onTime", (Object)onTime);
        props.put((Object)"offTime", (Object)offTime);
        this.context.resourceResolver().commit();
        Assert.assertEquals((Object)onTime.getTime(), (Object)this.page.getOnTime().getTime());
        Assert.assertEquals((Object)offTime.getTime(), (Object)this.page.getOffTime().getTime());
        Assert.assertFalse((boolean)this.page.isValid());
        Assert.assertTrue((this.page.timeUntilValid() < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testLastModified() {
        Assert.assertNotNull((Object)this.page.getLastModifiedBy());
        Assert.assertNotNull((Object)this.page.getLastModified());
    }

    @Test
    public void testTemplate() {
        this.context.load().json("/json-import-samples/application.json", "/apps/sample");
        Assert.assertNotNull((Object)this.page.getTemplate());
    }

    @Test
    public void testListChildren() {
        List childPages = IteratorUtils.toList((Iterator)this.page.listChildren());
        Assert.assertEquals((long)1L, (long)childPages.size());
    }

    @Test
    public void testListChildrenFiltered() {
        List childPages = IteratorUtils.toList((Iterator)this.page.listChildren((Filter)new Filter<Page>(){

            public boolean includes(Page element) {
                return !StringUtils.equals((CharSequence)"toolbar", (CharSequence)element.getName());
            }
        }));
        Assert.assertEquals((long)0L, (long)childPages.size());
    }

    @Test
    public void testListChildrenFilteredDeep() {
        List childPages = IteratorUtils.toList((Iterator)this.page.listChildren((Filter)new Filter<Page>(){

            public boolean includes(Page element) {
                return !StringUtils.equals((CharSequence)"toolbar", (CharSequence)element.getName());
            }
        }, true));
        Assert.assertEquals((long)1L, (long)childPages.size());
    }

    @Test
    public void testAdaptTo() {
        MockPage underTest = new MockPage(this.mockResource);
        Resource resource = (Resource)underTest.adaptTo(Resource.class);
        Assert.assertEquals((Object)this.mockResource, (Object)resource);
    }

    @Test
    public void testGetLanguage() {
        Page profilesPage = this.context.pageManager().getPage("/content/sample/en/toolbar/profiles");
        ModifiableValueMap props = (ModifiableValueMap)this.page.getContentResource().adaptTo(ModifiableValueMap.class);
        props.put((Object)"jcr:language", (Object)"fr_FR");
        Locale locale = profilesPage.getLanguage(false);
        Assert.assertEquals((Object)Locale.forLanguageTag("fr-FR"), (Object)locale);
        locale = profilesPage.getLanguage(true);
        Assert.assertEquals((Object)Locale.forLanguageTag("en"), (Object)locale);
    }

    @Test
    public void testEquals() throws Exception {
        Page page1 = this.context.pageManager().getPage("/content/sample/en");
        Page page2 = this.context.pageManager().getPage("/content/sample/en");
        Page page3 = this.context.pageManager().getPage("/content/sample/en/toolbar/profiles");
        Assert.assertTrue((boolean)page1.equals(page2));
        Assert.assertFalse((boolean)page1.equals(page3));
    }
}

