/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.RangeIterator;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import io.wcm.testing.mock.aem.MockTagManager;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockTagManagerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private String tagRoot;
    private ResourceResolver resolver;
    private TagManager tagManager;
    private Page rootPage;

    @Before
    public void setUp() throws Exception {
        this.tagRoot = MockTagManager.getTagRootPath();
        this.resolver = this.context.resourceResolver();
        this.context.load().json("/json-import-samples/tags.json", this.tagRoot);
        this.context.load().json("/json-import-samples/content.json", "/content/sample/en");
        this.resolver.commit();
        this.tagManager = (TagManager)this.resolver.adaptTo(TagManager.class);
        this.rootPage = (Page)this.resolver.getResource("/content/sample/en").adaptTo(Page.class);
    }

    @Test
    public void testGetPageTags() {
        Page page = this.rootPage;
        Tag[] pageTags = page.getTags();
        Assert.assertNotNull((Object)pageTags);
        Assert.assertEquals((long)2L, (long)pageTags.length);
        Assert.assertTrue((boolean)this.containsPath(pageTags, this.tagRoot + "/default/tagA"));
        Assert.assertTrue((boolean)this.containsPath(pageTags, this.tagRoot + "/wcmio/aem/api"));
        page = (Page)page.listChildren().next();
        pageTags = page.getTags();
        Assert.assertNotNull((Object)pageTags);
        Assert.assertEquals((long)2L, (long)pageTags.length);
        Assert.assertTrue((boolean)this.containsPath(pageTags, this.tagRoot + "/default/tagB"));
        Assert.assertTrue((boolean)this.containsPath(pageTags, this.tagRoot + "/wcmio/nondescript"));
        page = (Page)page.listChildren().next();
        pageTags = page.getTags();
        Assert.assertNotNull((Object)pageTags);
        Assert.assertEquals((long)0L, (long)pageTags.length);
    }

    @Test
    public void testGetNamespaces() {
        Tag[] namespaces = this.tagManager.getNamespaces();
        Assert.assertNotNull((Object)namespaces);
        Assert.assertEquals((long)2L, (long)namespaces.length);
        Assert.assertTrue((boolean)this.containsPath(namespaces, this.tagRoot + "/default"));
        Assert.assertTrue((boolean)this.containsPath(namespaces, this.tagRoot + "/wcmio"));
        Iterator namespacesIter = this.tagManager.getNamespacesIter();
        Assert.assertNotNull((Object)namespacesIter);
        Assert.assertTrue((boolean)namespacesIter.hasNext());
        Assert.assertEquals((Object)(this.tagRoot + "/default"), (Object)((Tag)namespacesIter.next()).getPath());
        Assert.assertTrue((boolean)namespacesIter.hasNext());
        Assert.assertEquals((Object)(this.tagRoot + "/wcmio"), (Object)((Tag)namespacesIter.next()).getPath());
        Assert.assertFalse((boolean)namespacesIter.hasNext());
    }

    @Test
    public void testCanCreateTag() throws InvalidTagFormatException {
        Assert.assertFalse((boolean)this.tagManager.canCreateTag(TagConstants.DEFAULT_NAMESPACE_ID));
        Assert.assertFalse((boolean)this.tagManager.canCreateTag("wcmio:"));
        Assert.assertTrue((boolean)this.tagManager.canCreateTag("wcmio"));
    }

    @Test
    public void testCreateTag() throws InvalidTagFormatException, PersistenceException {
        Tag existing = this.tagManager.createTag("wcmio:", "foo", "bar");
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((Object)(this.tagRoot + "/wcmio"), (Object)existing.getPath());
        Assert.assertEquals((Object)"WCM IO Tag Namespace", (Object)existing.getTitle());
        Assert.assertEquals((Object)"The WCM IO namespace for testing tag functionality", (Object)existing.getDescription());
        Tag newTag = this.tagManager.createTag("wcmio", "WCM Tag", "This exists in the default namespace", false);
        Assert.assertNotNull((Object)newTag);
        Assert.assertEquals((Object)(this.tagRoot + "/default/wcmio"), (Object)newTag.getPath());
        Assert.assertEquals((Object)"WCM Tag", (Object)newTag.getTitle());
        Assert.assertEquals((Object)"This exists in the default namespace", (Object)newTag.getDescription());
        if (this.context.resourceResolverType() != ResourceResolverType.JCR_MOCK) {
            Assert.assertTrue((boolean)this.resolver.hasChanges());
        }
        this.context.resourceResolver().commit();
        newTag = this.tagManager.createTag("wcmio:new", null, null);
        Assert.assertNotNull((Object)newTag);
        Assert.assertEquals((Object)(this.tagRoot + "/wcmio/new"), (Object)newTag.getPath());
        Assert.assertEquals((Object)newTag.getName(), (Object)newTag.getTitle());
        Assert.assertNull((Object)newTag.getDescription());
        if (this.context.resourceResolverType() != ResourceResolverType.JCR_MOCK) {
            Assert.assertFalse((boolean)this.resolver.hasChanges());
        }
    }

    @Test
    public void setTags() {
        Page page = this.rootPage;
        Object[] startTags = page.getTags();
        this.tagManager.setTags(page.getContentResource(), null, false);
        Object[] currentTags = page.getTags();
        Assert.assertNotNull((Object)currentTags);
        Assert.assertEquals((long)0L, (long)currentTags.length);
        Assert.assertNotEquals((long)startTags.length, (long)currentTags.length);
        if (this.context.resourceResolverType() != ResourceResolverType.JCR_MOCK) {
            Assert.assertTrue((boolean)this.resolver.hasChanges());
        }
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            Assert.fail((String)e.getMessage());
        }
        this.tagManager.setTags(page.getContentResource(), (Tag[])startTags);
        currentTags = page.getTags();
        Assert.assertNotNull((Object)currentTags);
        Assert.assertArrayEquals((Object[])startTags, (Object[])currentTags);
        if (this.context.resourceResolverType() != ResourceResolverType.JCR_MOCK) {
            Assert.assertFalse((boolean)this.resolver.hasChanges());
        }
    }

    @Test
    public void testFind() {
        RangeIterator resources = this.tagManager.find("wcmio:");
        Assert.assertNotNull((Object)resources);
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((long)2L, (long)resources.getSize());
        Assert.assertEquals((long)0L, (long)resources.getPosition());
        Assert.assertEquals((Object)"/content/sample/en/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((long)1L, (long)resources.getPosition());
        Assert.assertEquals((Object)"/content/sample/en/toolbar/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        Assert.assertEquals((long)2L, (long)resources.getPosition());
        resources = this.tagManager.find("/content/sample/en/toolbar", new String[]{"wcmio:"});
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)0L, (long)resources.getPosition());
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((long)1L, (long)resources.getSize());
        Assert.assertEquals((Object)"/content/sample/en/toolbar/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        Assert.assertEquals((long)1L, (long)resources.getPosition());
        resources = this.tagManager.find("/content", new String[]{"wcmio:nondescript", this.tagRoot + "/default"}, false);
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)0L, (long)resources.getPosition());
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((long)1L, (long)resources.getSize());
        Assert.assertEquals((Object)"/content/sample/en/toolbar/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        Assert.assertEquals((long)1L, (long)resources.getPosition());
        resources = this.tagManager.find("/content", new String[]{"wcmio:nondescript", this.tagRoot + "/default"}, true);
        Assert.assertNotNull((Object)resources);
        Assert.assertEquals((long)0L, (long)resources.getPosition());
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((long)2L, (long)resources.getSize());
        Assert.assertEquals((Object)"/content/sample/en/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertEquals((Object)"/content/sample/en/toolbar/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        Assert.assertEquals((long)2L, (long)resources.getPosition());
        resources = this.tagManager.find("/content", new String[]{"wcmio:nondescrip", this.tagRoot + "/default"}, true);
        Assert.assertNull((Object)resources);
    }

    @Test
    public void testResolve() {
        Tag tag = this.tagManager.resolve("wcmio:");
        Assert.assertNotNull((Object)tag);
        Assert.assertEquals((Object)"wcmio:", (Object)tag.getTagID());
        tag = this.tagManager.resolve("wcmio");
        Assert.assertNull((Object)tag);
    }

    @Test
    public void testGetTagsForSubtree() {
        Tag[] tags = this.tagManager.getTagsForSubtree((Resource)this.rootPage.adaptTo(Resource.class), false);
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)4L, (long)tags.length);
        Assert.assertTrue((boolean)this.containsPath(tags, this.tagRoot + "/default/tagA"));
        Assert.assertTrue((boolean)this.containsPath(tags, this.tagRoot + "/wcmio/aem/api"));
        Assert.assertTrue((boolean)this.containsPath(tags, this.tagRoot + "/default/tagB"));
        Assert.assertTrue((boolean)this.containsPath(tags, this.tagRoot + "/wcmio/nondescript"));
    }

    private boolean containsPath(Tag[] tags, String path) {
        for (Tag tag : tags) {
            if (!StringUtils.equals((CharSequence)tag.getPath(), (CharSequence)path)) continue;
            return true;
        }
        return false;
    }
}

