/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Filter;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagManager;
import io.wcm.testing.mock.aem.MockTagManager;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockTagTest {
    private static final String XPATH_PROPERTY = "@p";
    private static final String XPATH_PROPERTY_IN_JCR_CONTENT = "jcr:content/@p";
    private static final String XPATH_PROPERTY_IN_SUB_SUB_NODE = "jcr:content/test/@p";
    private static final Map<String, String> TAG_PROPERTY_CONVERSIONS = Map.of("jcr:content/@p", "jcr:content/@p", "jcr:content/p", "jcr:content/@p", "@jcr:content/p", "jcr:content/@p", "p", "@p", "@p", "@p", "jcr:content/test/@p", "jcr:content/test/@p", "@jcr:content/test/p", "jcr:content/test/@p", "@jcr:content/@test/p", "jcr:content/_x0040_test/@p", "123", "@_x0031_23");
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private String tagRoot;
    private ResourceResolver resolver;
    private TagManager tagManager;
    private Tag wcmio;
    private Tag aem;
    private Tag aemApi;
    private Tag nondescript;
    private Tag nondescript2;
    private static final Locale LOCALE_PT_BR = new Locale("pt", "br");

    @Before
    public void setUp() throws Exception {
        this.tagRoot = MockTagManager.getTagRootPath();
        this.resolver = this.context.resourceResolver();
        this.context.load().json("/json-import-samples/tags.json", this.tagRoot);
        this.context.load().json("/json-import-samples/content.json", "/content/sample/en");
        this.resolver.commit();
        this.tagManager = (TagManager)this.resolver.adaptTo(TagManager.class);
        this.wcmio = this.tagManager.resolve("wcmio:");
        this.aem = this.tagManager.resolve("wcmio:aem");
        this.aemApi = this.tagManager.resolve("wcmio:aem/api");
        this.nondescript = this.tagManager.resolve("wcmio:nondescript");
        this.nondescript2 = this.tagManager.resolve("wcmio:nondescript/nondescript2");
    }

    @Test
    public void testNamespaces() {
        Tag[] namespaces = this.tagManager.getNamespaces();
        Assert.assertNotNull((Object)namespaces);
        for (Tag namespace : namespaces) {
            Assert.assertTrue((boolean)namespace.isNamespace());
            Assert.assertNull((Object)namespace.getParent());
            Assert.assertEquals((Object)"", (Object)namespace.getLocalTagID());
            Assert.assertEquals((Object)(namespace.getName() + TagConstants.NAMESPACE_DELIMITER), (Object)namespace.getTagID());
            Assert.assertEquals((Object)namespace, (Object)namespace.getNamespace());
            Assert.assertEquals((Object)(this.tagRoot + "/" + namespace.getName()), (Object)namespace.getPath());
        }
    }

    @Test
    public void testListChildren() {
        Tag childTag;
        Assert.assertNotNull((Object)this.wcmio);
        Iterator children = this.wcmio.listChildren();
        Assert.assertNotNull((Object)children);
        int childCount = 0;
        while (children.hasNext()) {
            childTag = (Tag)children.next();
            Assert.assertNotNull((Object)childTag);
            Assert.assertFalse((boolean)childTag.isNamespace());
            Assert.assertEquals((Object)this.wcmio, (Object)childTag.getNamespace());
            Assert.assertEquals((Object)this.wcmio, (Object)childTag.getParent());
            Assert.assertEquals((Object)(this.wcmio.getPath() + "/" + childTag.getName()), (Object)childTag.getPath());
            Assert.assertEquals((Object)(this.wcmio.getTagID() + childTag.getName()), (Object)childTag.getTagID());
            Assert.assertEquals((Object)childTag.getName(), (Object)childTag.getLocalTagID());
            ++childCount;
        }
        Assert.assertEquals((long)3L, (long)childCount);
        Assert.assertNotNull((Object)this.aem);
        children = this.aem.listChildren();
        Assert.assertNotNull((Object)children);
        childCount = 0;
        while (children.hasNext()) {
            childTag = (Tag)children.next();
            Assert.assertNotNull((Object)childTag);
            Assert.assertFalse((boolean)childTag.isNamespace());
            Assert.assertEquals((Object)this.aem.getNamespace(), (Object)childTag.getNamespace());
            Assert.assertEquals((Object)this.aem, (Object)childTag.getParent());
            Assert.assertEquals((Object)(this.aem.getPath() + "/" + childTag.getName()), (Object)childTag.getPath());
            Assert.assertEquals((Object)(this.aem.getTagID() + "/" + childTag.getName()), (Object)childTag.getTagID());
            Assert.assertEquals((Object)(this.aem.getName() + "/" + childTag.getName()), (Object)childTag.getLocalTagID());
            ++childCount;
        }
        Assert.assertEquals((long)2L, (long)childCount);
        children = this.aem.listChildren((Filter)new NothingFilter());
        Assert.assertNotNull((Object)children);
        Assert.assertFalse((boolean)children.hasNext());
        children = this.wcmio.listAllSubTags();
        Assert.assertNotNull((Object)children);
        childCount = 0;
        while (children.hasNext()) {
            childTag = (Tag)children.next();
            Assert.assertNotNull((Object)childTag);
            Assert.assertFalse((boolean)childTag.isNamespace());
            Assert.assertNotNull((Object)childTag.getParent());
            Assert.assertEquals((Object)this.wcmio, (Object)childTag.getNamespace());
            Resource childTagResource = (Resource)childTag.adaptTo(Resource.class);
            Assert.assertNotNull((Object)childTagResource);
            Assert.assertEquals((Object)childTagResource.getName(), (Object)childTag.getName());
            Assert.assertTrue((boolean)childTag.getPath().startsWith(this.wcmio.getPath() + "/"));
            Assert.assertTrue((boolean)childTag.getTagID().startsWith(this.wcmio.getTagID()));
            ++childCount;
        }
        Assert.assertEquals((long)6L, (long)childCount);
    }

    @Test
    public void testLocalizedTitles() {
        Assert.assertNull((Object)this.wcmio.getLocalizedTitle(null));
        Assert.assertNull((Object)this.wcmio.getLocalizedTitle(Locale.ENGLISH));
        Map localizedTitles = this.wcmio.getLocalizedTitles();
        Assert.assertNotNull((Object)localizedTitles);
        Assert.assertEquals((long)0L, (long)localizedTitles.size());
        Assert.assertNull((Object)this.aem.getLocalizedTitle(null));
        Assert.assertNull((Object)this.aem.getLocalizedTitle(Locale.ENGLISH));
        localizedTitles = this.aem.getLocalizedTitles();
        Assert.assertNotNull((Object)localizedTitles);
        Assert.assertEquals((long)0L, (long)localizedTitles.size());
        Assert.assertNull((Object)this.aemApi.getLocalizedTitle(null));
        Assert.assertEquals((Object)"English AEM API", (Object)this.aemApi.getLocalizedTitle(Locale.ENGLISH));
        Assert.assertEquals((Object)"AEM API for US", (Object)this.aemApi.getLocalizedTitle(Locale.US));
        Assert.assertEquals((Object)"German AEM API", (Object)this.aemApi.getLocalizedTitle(Locale.GERMAN));
        Assert.assertEquals((Object)"AEM API for Germany", (Object)this.aemApi.getLocalizedTitle(Locale.GERMANY));
        Assert.assertEquals((Object)"Japanese AEM API", (Object)this.aemApi.getLocalizedTitle(Locale.JAPANESE));
        Assert.assertEquals((Object)"Japanese AEM API", (Object)this.aemApi.getLocalizedTitle(Locale.JAPAN));
        Assert.assertEquals((Object)"Portuguese (Brazil) AEM API  with special chars", (Object)this.aemApi.getLocalizedTitle(LOCALE_PT_BR));
        localizedTitles = this.aemApi.getLocalizedTitles();
        Assert.assertNotNull((Object)localizedTitles);
        Assert.assertEquals((long)6L, (long)localizedTitles.size());
        Assert.assertEquals((Object)"English AEM API", localizedTitles.get(Locale.ENGLISH));
        Assert.assertEquals((Object)"AEM API for US", localizedTitles.get(Locale.US));
        Assert.assertEquals((Object)"German AEM API", localizedTitles.get(Locale.GERMAN));
        Assert.assertEquals((Object)"AEM API for Germany", localizedTitles.get(Locale.GERMANY));
        Assert.assertEquals((Object)"Japanese AEM API", localizedTitles.get(Locale.JAPANESE));
        Assert.assertEquals((Object)"Portuguese (Brazil) AEM API/:with special chars", localizedTitles.get(LOCALE_PT_BR));
        Assert.assertEquals(null, localizedTitles.get(Locale.JAPAN));
    }

    @Test
    public void testTitle() {
        Assert.assertEquals((Object)"AEM", (Object)this.aem.getTitle());
        Assert.assertEquals((Object)"AEM", (Object)this.aem.getTitle(Locale.ENGLISH));
        Assert.assertEquals((Object)"AEM", (Object)this.aem.getTitle(Locale.US));
        Assert.assertEquals((Object)"AEM API", (Object)this.aemApi.getTitle());
        Assert.assertEquals((Object)"English AEM API", (Object)this.aemApi.getTitle(Locale.ENGLISH));
        Assert.assertEquals((Object)"AEM API for US", (Object)this.aemApi.getTitle(Locale.US));
    }

    @Test
    public void testTitlePath() {
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM", (Object)this.aem.getTitlePath());
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM", (Object)this.aem.getTitlePath(Locale.ENGLISH));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM", (Object)this.aem.getTitlePath(Locale.US));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / AEM API", (Object)this.aemApi.getTitlePath());
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / AEM API", (Object)this.aemApi.getTitlePath(Locale.ENGLISH));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / AEM API", (Object)this.aemApi.getTitlePath(Locale.US));
    }

    @Test
    public void testLastModified() {
        Assert.assertEquals((long)1282593744000L, (long)this.wcmio.getLastModified());
        Assert.assertEquals((long)1282672944000L, (long)this.aem.getLastModified());
        Assert.assertEquals((long)0L, (long)this.aemApi.getLastModified());
    }

    @Test
    public void testLastModifiedBy() {
        Assert.assertEquals((Object)"admin", (Object)this.wcmio.getLastModifiedBy());
        Assert.assertEquals((Object)"wcmio", (Object)this.aem.getLastModifiedBy());
        Assert.assertEquals(null, (Object)this.aemApi.getLastModifiedBy());
    }

    @Test
    public void testDescription() {
        Assert.assertEquals((Object)"The WCM IO namespace for testing tag functionality", (Object)this.wcmio.getDescription());
        Assert.assertEquals((Object)"Tag representing AEM", (Object)this.aem.getDescription());
        Assert.assertEquals(null, (Object)this.nondescript.getDescription());
    }

    @Test
    public void testCount() {
        Assert.assertEquals((long)2L, (long)this.wcmio.getCount());
        Assert.assertEquals((long)1L, (long)this.aem.getCount());
        Assert.assertEquals((long)1L, (long)this.nondescript.getCount());
        Assert.assertEquals((long)0L, (long)this.nondescript2.getCount());
    }

    @Test
    public void testFind() {
        Iterator resources = this.wcmio.find();
        Assert.assertNotNull((Object)resources);
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((Object)"/content/sample/en/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((Object)"/content/sample/en/toolbar/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        resources = this.aem.find();
        Assert.assertNotNull((Object)resources);
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((Object)"/content/sample/en/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        resources = this.nondescript.find();
        Assert.assertNotNull((Object)resources);
        Assert.assertTrue((boolean)resources.hasNext());
        Assert.assertEquals((Object)"/content/sample/en/toolbar/jcr:content", (Object)((Resource)resources.next()).getPath());
        Assert.assertFalse((boolean)resources.hasNext());
        resources = this.nondescript2.find();
        Assert.assertNotNull((Object)resources);
        Assert.assertFalse((boolean)resources.hasNext());
    }

    @Test
    public void testGetXPathSearchExpression() throws Exception {
        Tag tag = this.tagManager.createTag("test:tag1", "Tag 1", null);
        this.assertTagExpression(tag, "test:tag1", "test/tag1");
    }

    @Test
    public void testGetXPathSearchExpression_2Level() throws Exception {
        Tag tag = this.tagManager.createTag("test:tag1/tag2", "Tag 2", null);
        this.assertTagExpression(tag, "test:tag1/tag2", "test/tag1/tag2");
    }

    @Test
    public void testGetXPathSearchExpression_DefaultNamespace() throws Exception {
        Tag tag = this.tagManager.createTag("tag3", "Tag 3", null);
        this.assertTagExpression(tag, "tag3", "default/tag3");
    }

    @Test
    public void getLocalizedTitlePaths() {
        Map localizedTitlePaths = this.aemApi.getLocalizedTitlePaths();
        Assert.assertNotNull((Object)localizedTitlePaths);
        Assert.assertEquals((long)6L, (long)localizedTitlePaths.size());
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / English AEM API", localizedTitlePaths.get(Locale.ENGLISH));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / AEM API for US", localizedTitlePaths.get(Locale.US));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / German AEM API", localizedTitlePaths.get(Locale.GERMAN));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / AEM API for Germany", localizedTitlePaths.get(Locale.GERMANY));
        Assert.assertEquals((Object)"WCM IO Tag Namespace : AEM / Portuguese (Brazil) AEM API/:with special chars", localizedTitlePaths.get(LOCALE_PT_BR));
    }

    private void assertTagExpression(@NotNull Tag tag, @NotNull String tagId, @NotNull String tagPath) {
        for (Map.Entry<String, String> entry : TAG_PROPERTY_CONVERSIONS.entrySet()) {
            String property = entry.getKey();
            String expectedXpathProperty = entry.getValue();
            Assert.assertEquals((Object)("(" + expectedXpathProperty + "='" + tagId + "' or " + expectedXpathProperty + "='" + this.tagRoot + "/" + tagPath + "' or jcr:like(" + expectedXpathProperty + ", '" + tagId + "/%') or jcr:like(" + expectedXpathProperty + ", '" + this.tagRoot + "/" + tagPath + "/%'))"), (Object)tag.getXPathSearchExpression(property));
        }
    }

    private static class NothingFilter
    implements Filter<Tag> {
        private NothingFilter() {
        }

        public boolean includes(Tag tag) {
            return false;
        }
    }
}

