/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.builder;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.day.image.Layer;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ContentBuilderTest {
    private static final String TEMPLATE = "/apps/sample/templates/sample";
    private String contentRoot;
    private String damRoot;
    @Rule
    public AemContext context = TestAemContext.newAemContext();

    @Before
    public void setUp() {
        this.contentRoot = this.context.uniqueRoot().content();
        this.damRoot = this.context.uniqueRoot().dam();
    }

    @Test
    public void testPage() {
        Page page = this.context.create().page(this.contentRoot + "/test1/page1");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"page1", (Object)page.getName());
        Assert.assertEquals((Object)"/apps/sample/templates/template1", (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"page1", (Object)page.getTitle());
    }

    @Test
    public void testPageWithTemplate() {
        Page page = this.context.create().page(this.contentRoot + "/test1/page1", TEMPLATE);
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"page1", (Object)page.getName());
        Assert.assertEquals((Object)TEMPLATE, (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"page1", (Object)page.getTitle());
    }

    @Test
    public void testPageWithTitle() {
        Page page = this.context.create().page(this.contentRoot + "/test1/page1/subpage1", TEMPLATE, "Test Title");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"subpage1", (Object)page.getName());
        Assert.assertEquals((Object)TEMPLATE, (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"Test Title", (Object)page.getTitle());
    }

    @Test
    public void testPageWithProperties() {
        Page page = this.context.create().page(this.contentRoot + "/test1/page2", TEMPLATE, new Object[]{"jcr:title", "Test Title", "stringProp", "value1"});
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"page2", (Object)page.getName());
        Assert.assertEquals((Object)TEMPLATE, (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"Test Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"value1", (Object)page.getProperties().get("stringProp", String.class));
    }

    @Test
    public void testPage_withParentPage() {
        Page parentPage = this.context.create().page(this.contentRoot + "/test1");
        Page page = this.context.create().page(parentPage, "page1");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"page1", (Object)page.getName());
        Assert.assertEquals((Object)"/apps/sample/templates/template1", (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"page1", (Object)page.getTitle());
    }

    @Test
    public void testPageWithTemplate_withParentPage() {
        Page parentPage = this.context.create().page(this.contentRoot + "/test1");
        Page page = this.context.create().page(parentPage, "page1", TEMPLATE);
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"page1", (Object)page.getName());
        Assert.assertEquals((Object)TEMPLATE, (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"page1", (Object)page.getTitle());
    }

    @Test
    public void testPageWithTitle_withParentPage() {
        Page parentPage = this.context.create().page(this.contentRoot + "/test1");
        Page page = this.context.create().page(parentPage, "page1/subpage1", TEMPLATE, "Test Title");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"subpage1", (Object)page.getName());
        Assert.assertEquals((Object)TEMPLATE, (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"Test Title", (Object)page.getTitle());
    }

    @Test
    public void testPageWithProperties_withParentPage() {
        Page parentPage = this.context.create().page(this.contentRoot + "/test1");
        Page page = this.context.create().page(parentPage, "page2", TEMPLATE, new Object[]{"jcr:title", "Test Title", "stringProp", "value1"});
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"page2", (Object)page.getName());
        Assert.assertEquals((Object)TEMPLATE, (Object)page.getProperties().get("cq:template", String.class));
        Assert.assertEquals((Object)"Test Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"value1", (Object)page.getProperties().get("stringProp", String.class));
    }

    @Test
    public void testResource() {
        Resource resource = this.context.create().resource(this.contentRoot + "/test1/resource1");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"resource1", (Object)resource.getName());
        Assert.assertTrue((resource.getValueMap().isEmpty() || Map.of("jcr:primaryType", "nt:unstructured").equals(resource.getValueMap()) ? 1 : 0) != 0);
    }

    @Test
    public void testResourceWithProperties() {
        Resource resource = this.context.create().resource(this.contentRoot + "/test1/resource2", new Object[]{"jcr:title", "Test Title", "stringProp", "value1"});
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"resource2", (Object)resource.getName());
        Assert.assertEquals((Object)"Test Title", (Object)resource.getValueMap().get("jcr:title", String.class));
        Assert.assertEquals((Object)"value1", (Object)resource.getValueMap().get("stringProp", String.class));
    }

    @Test
    public void testAssetFromClasspath() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.gif", "/sample-image.gif", "image/gif");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"sample1.gif", (Object)asset.getName());
        Assert.assertEquals((Object)"image/gif", (Object)asset.getOriginal().getMimeType());
        Assert.assertEquals((Object)"2", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"2", (Object)asset.getMetadataValue("tiff:ImageLength"));
        try (InputStream is = (InputStream)asset.getOriginal().adaptTo(InputStream.class);){
            Layer layer = new Layer(is);
            Assert.assertEquals((long)2L, (long)layer.getWidth());
            Assert.assertEquals((long)2L, (long)layer.getHeight());
        }
        Rendition rendition = this.context.create().assetRendition(asset, "sample2.gif", "/sample-image.gif", "image/gif");
        Assert.assertEquals((Object)"sample2.gif", (Object)rendition.getName());
        Assert.assertEquals((Object)"image/gif", (Object)rendition.getMimeType());
        Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
    }

    @Test
    public void testAssetFromByteArray() throws Exception {
        Asset asset;
        try (ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{1, 2, 3});){
            asset = this.context.create().asset(this.damRoot + "/sample1.bin", (InputStream)is, "application/octet-stream");
            Assert.assertNotNull((Object)asset);
            Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
            Assert.assertEquals((Object)"sample1.bin", (Object)asset.getName());
            Assert.assertEquals((Object)"application/octet-stream", (Object)asset.getOriginal().getMimeType());
        }
        is = new ByteArrayInputStream(new byte[]{4, 5, 6});
        try {
            Rendition rendition = this.context.create().assetRendition(asset, "sample2.bin", (InputStream)is, "application/octet-stream");
            Assert.assertEquals((Object)"sample2.bin", (Object)rendition.getName());
            Assert.assertEquals((Object)"application/octet-stream", (Object)rendition.getMimeType());
            Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Test
    public void testAssetFromWidthHeight_Jpeg() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.jpg", 100L, 50L, "image/jpeg");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"sample1.jpg", (Object)asset.getName());
        Assert.assertEquals((Object)"image/jpeg", (Object)asset.getOriginal().getMimeType());
        Assert.assertEquals((Object)"100", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"50", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition rendition = this.context.create().assetRendition(asset, "sample2.jpg", 20L, 20L, "image/jpeg");
        Assert.assertEquals((Object)"sample2.jpg", (Object)rendition.getName());
        Assert.assertEquals((Object)"image/jpeg", (Object)rendition.getMimeType());
        Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
        Rendition webEnabledRendition = this.context.create().assetRenditionWebEnabled(asset);
        Assert.assertEquals((Object)"cq5dam.web.1280.1280.jpg", (Object)webEnabledRendition.getName());
        Assert.assertEquals((Object)"image/jpeg", (Object)webEnabledRendition.getMimeType());
        Assert.assertEquals((long)3L, (long)asset.getRenditions().size());
        this.assertRatio(asset.getOriginal(), webEnabledRendition);
    }

    @Test
    public void testAssetFromWidthHeight_Jpeg_BigImage_WebEnabled_Ratio1() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.jpg", 2000L, 1000L, "image/jpeg");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((Object)"2000", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"1000", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition webEnabledRendition = this.context.create().assetRenditionWebEnabled(asset);
        Assert.assertEquals((Object)"cq5dam.web.1280.1280.jpg", (Object)webEnabledRendition.getName());
        this.assertRatio(asset.getOriginal(), webEnabledRendition);
    }

    @Test
    public void testAssetFromWidthHeight_Jpeg_BigImage_WebEnabled_Ratio2() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.jpg", 1000L, 2000L, "image/jpeg");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((Object)"1000", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"2000", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition webEnabledRendition = this.context.create().assetRenditionWebEnabled(asset);
        Assert.assertEquals((Object)"cq5dam.web.1280.1280.jpg", (Object)webEnabledRendition.getName());
        this.assertRatio(asset.getOriginal(), webEnabledRendition);
    }

    @Test
    public void testAssetFromWidthHeight_Gif() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.gif", 100L, 50L, "image/gif");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"sample1.gif", (Object)asset.getName());
        Assert.assertEquals((Object)"image/gif", (Object)asset.getOriginal().getMimeType());
        Assert.assertEquals((Object)"100", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"50", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition rendition = this.context.create().assetRendition(asset, "sample2.gif", 20L, 20L, "image/gif");
        Assert.assertEquals((Object)"sample2.gif", (Object)rendition.getName());
        Assert.assertEquals((Object)"image/gif", (Object)rendition.getMimeType());
        Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
    }

    @Test
    public void testAssetFromWidthHeight_Tiff() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.tif", 100L, 50L, "image/tiff");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"sample1.tif", (Object)asset.getName());
        Assert.assertEquals((Object)"image/tiff", (Object)asset.getOriginal().getMimeType());
        Assert.assertEquals((Object)"100", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"50", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition rendition = this.context.create().assetRendition(asset, "sample2.tif", 20L, 20L, "image/tiff");
        Assert.assertEquals((Object)"sample2.tif", (Object)rendition.getName());
        Assert.assertEquals((Object)"image/tiff", (Object)rendition.getMimeType());
        Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
    }

    @Test
    public void testAssetFromWidthHeight_SVG() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.svg", 100L, 50L, "image/svg+xml");
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"sample1.svg", (Object)asset.getName());
        Assert.assertEquals((Object)"image/svg+xml", (Object)asset.getOriginal().getMimeType());
        Assert.assertEquals((Object)"100", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"50", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition rendition = this.context.create().assetRendition(asset, "sample2.svg", 20L, 20L, "image/svg+xml");
        Assert.assertEquals((Object)"sample2.svg", (Object)rendition.getName());
        Assert.assertEquals((Object)"image/svg+xml", (Object)rendition.getMimeType());
        Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
    }

    @Test
    public void testAssetWithMetadata() throws Exception {
        Asset asset = this.context.create().asset(this.damRoot + "/sample1.jpg", 100L, 50L, "image/jpeg", new Object[]{"prop1", "value1", "prop2", 1});
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((long)1L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"sample1.jpg", (Object)asset.getName());
        Assert.assertEquals((Object)"image/jpeg", (Object)asset.getOriginal().getMimeType());
        Assert.assertEquals((Object)"100", (Object)asset.getMetadataValue("tiff:ImageWidth"));
        Assert.assertEquals((Object)"50", (Object)asset.getMetadataValue("tiff:ImageLength"));
        Rendition rendition = this.context.create().assetRendition(asset, "sample2.jpg", 20L, 20L, "image/jpeg");
        Assert.assertEquals((Object)"sample2.jpg", (Object)rendition.getName());
        Assert.assertEquals((Object)"image/jpeg", (Object)rendition.getMimeType());
        Assert.assertEquals((long)2L, (long)asset.getRenditions().size());
        Assert.assertEquals((Object)"value1", (Object)asset.getMetadata("prop1"));
        Assert.assertEquals((Object)"1", (Object)asset.getMetadataValue("prop2"));
    }

    @Test
    public void testTag() {
        Tag tag1 = this.context.create().tag("test:tag1");
        Tag tag2 = this.context.create().tag("test:tag1/tag2");
        Assert.assertEquals((Object)"test:tag1", (Object)tag1.getTagID());
        Assert.assertEquals((Object)"test:tag1/tag2", (Object)tag2.getTagID());
        Assert.assertEquals((Object)"tag1", (Object)tag1.getName());
        Assert.assertEquals((Object)"tag2", (Object)tag2.getName());
    }

    @Test
    public void testResourceInPage() {
        Page page = this.context.create().page(this.contentRoot + "/test1/page1");
        Resource resource1 = this.context.create().resource(page, "test1");
        Assert.assertNotNull((Object)resource1);
        Assert.assertEquals((Object)(this.contentRoot + "/test1/page1/jcr:content/test1"), (Object)resource1.getPath());
        Resource resource2 = this.context.create().resource(page, "/test2/test21", new Object[]{"prop1", "value1"});
        Assert.assertNotNull((Object)resource2);
        Assert.assertEquals((Object)(this.contentRoot + "/test1/page1/jcr:content/test2/test21"), (Object)resource2.getPath());
        Assert.assertEquals((Object)"value1", (Object)resource2.getValueMap().get("prop1", String.class));
    }

    private void assertRatio(Rendition expected, Rendition actual) {
        Layer expectedLayer = (Layer)((Resource)expected.adaptTo(Resource.class)).adaptTo(Layer.class);
        Layer actualLayer = (Layer)((Resource)actual.adaptTo(Resource.class)).adaptTo(Layer.class);
        Assert.assertEquals((String)"Ratio does not match", (double)(expectedLayer.getWidth() / expectedLayer.getHeight()), (double)(actualLayer.getWidth() / actualLayer.getHeight()), (double)1.0E-4);
    }
}

