/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.DamEvent;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MockAssetManagerTest {
    @Rule
    public AemContext context = TestAemContext.newAemContext();
    private DamEventHandler damEventHandler;

    @Before
    public void setUp() {
        this.damEventHandler = (DamEventHandler)this.context.registerService(EventHandler.class, new DamEventHandler());
    }

    @Test
    public void testCreateAsset() throws IOException {
        InputStream testImage = this.openTestAsset();
        String assetName = "myasset.gif";
        String mimeType = "image/gif";
        Asset asset = this.context.assetManager().createAsset(this.context.uniqueRoot().dam() + "/" + assetName, testImage, "image/gif", true);
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getOriginal().getStream());
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)this.openTestAsset(), (InputStream)asset.getOriginal().getStream()));
        Assert.assertEquals((Object)asset.getName(), (Object)assetName);
        Assert.assertEquals((Object)asset.getMimeType(), (Object)mimeType);
        List<DamEvent> damEvents = this.damEventHandler.getLastEvents(2);
        Assert.assertEquals((long)2L, (long)damEvents.size());
        Assert.assertEquals((Object)DamEvent.Type.RENDITION_UPDATED, (Object)damEvents.get(0).getType());
        Assert.assertEquals((Object)asset.getPath(), (Object)damEvents.get(0).getAssetPath());
        Assert.assertEquals((Object)asset.getOriginal().getPath(), (Object)damEvents.get(0).getAdditionalInfo());
        Assert.assertEquals((Object)DamEvent.Type.ASSET_CREATED, (Object)damEvents.get(1).getType());
        Assert.assertEquals((Object)asset.getPath(), (Object)damEvents.get(1).getAssetPath());
    }

    @Test
    public void testCreateAssetWithoutOriginalRendition() throws IOException {
        String assetName = "myasset.gif";
        Asset asset = this.context.assetManager().createAsset(this.context.uniqueRoot().dam() + "/" + assetName, null, null, true);
        Assert.assertNotNull((Object)asset);
        Assert.assertNull((Object)asset.getOriginal());
        Assert.assertEquals((Object)asset.getName(), (Object)assetName);
        Assert.assertEquals((Object)"", (Object)asset.getMimeType());
        Optional<DamEvent> damEvent = this.damEventHandler.getLastEvent();
        Assert.assertTrue((boolean)damEvent.isPresent());
        Assert.assertEquals((Object)DamEvent.Type.ASSET_CREATED, (Object)damEvent.get().getType());
        Assert.assertEquals((Object)asset.getPath(), (Object)damEvent.get().getAssetPath());
        InputStream testImage = this.openTestAsset();
        String mimeType = "image/gif";
        asset = this.context.assetManager().createAsset(this.context.uniqueRoot().dam() + "/" + assetName, testImage, "image/gif", true);
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getOriginal().getStream());
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)this.openTestAsset(), (InputStream)asset.getOriginal().getStream()));
        Assert.assertEquals((Object)asset.getName(), (Object)assetName);
        Assert.assertEquals((Object)asset.getMimeType(), (Object)mimeType);
    }

    private InputStream openTestAsset() {
        return this.getClass().getClassLoader().getResourceAsStream("sample-image.gif");
    }

    static final class DamEventHandler
    implements EventHandler {
        private final List<DamEvent> events = new ArrayList<DamEvent>();

        DamEventHandler() {
        }

        public void handleEvent(Event event) {
            if (StringUtils.equals((CharSequence)event.getTopic(), (CharSequence)"com/day/cq/dam")) {
                this.events.add(DamEvent.fromEvent((Event)event));
            }
        }

        public List<DamEvent> getEvents() {
            return this.events;
        }

        public Optional<DamEvent> getLastEvent() {
            if (this.events.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.events.get(this.events.size() - 1));
        }

        public List<DamEvent> getLastEvents(int number) {
            ArrayList<DamEvent> result = new ArrayList<DamEvent>();
            for (int i = this.events.size() - number; i < this.events.size(); ++i) {
                result.add(this.events.get(i));
            }
            return result;
        }
    }
}

