/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.granite;

import com.adobe.granite.workflow.collection.ResourceCollection;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import io.wcm.testing.mock.aem.context.TestAemContext;
import io.wcm.testing.mock.aem.junit.AemContext;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockResourceCollectionManagerTest {
    private static final String PKG_ROOT = "/var/workflow/packages";
    @Rule
    public AemContext context = TestAemContext.newAemContext(ResourceResolverType.JCR_MOCK, ResourceResolverType.JCR_OAK);
    private ResourceCollectionManager underTest;
    private Page samplePage1;
    private Page samplePage2;
    private Asset sampleAsset;

    @Before
    public void setUp() throws Exception {
        this.underTest = (ResourceCollectionManager)this.context.getService(ResourceCollectionManager.class);
        this.samplePage1 = this.context.create().page("/content/mysite/page1");
        this.samplePage2 = this.context.create().page("/content/mysite/page2");
        this.sampleAsset = this.context.create().asset("/content/dam/asset1.jpg", 10L, 10L, "image/jpeg");
    }

    @Test
    public void testCreateCollection_NoPackage() {
        Resource anyResource = this.context.create().resource("/var/workflow/packages/anyResource");
        ResourceCollection result = this.underTest.createCollection((Node)anyResource.adaptTo(Node.class));
        Assert.assertNull((Object)result);
    }

    @Test
    public void testCreateCollection_WithPackage() throws RepositoryException {
        this.createPackage("/var/workflow/packages/pkg1", this.samplePage1.getPath(), this.sampleAsset.getPath(), this.samplePage2.getPath(), "/invalid/path");
        Resource vltDef = this.context.resourceResolver().getResource("/var/workflow/packages/pkg1/jcr:content/vlt:definition");
        ResourceCollection result = this.underTest.createCollection((Node)vltDef.adaptTo(Node.class));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"/var/workflow/packages/pkg1", (Object)result.getPath());
        this.assertPaths(result.list(new String[]{"cq:Page"}), this.samplePage1.getPath(), this.samplePage2.getPath());
        this.assertPaths(result.list(new String[]{"dam:Asset"}), this.sampleAsset.getPath());
    }

    @Test
    public void testGetCollectionsForNode() throws RepositoryException {
        this.createPackage("/var/workflow/packages/pkg1", this.samplePage1.getPath(), this.sampleAsset.getPath());
        this.createPackage("/var/workflow/packages/pkg2", this.samplePage2.getPath());
        Resource pkg1 = this.context.resourceResolver().getResource("/var/workflow/packages/pkg1");
        Resource pkg2 = this.context.resourceResolver().getResource("/var/workflow/packages/pkg2");
        Resource all = this.context.resourceResolver().getResource(PKG_ROOT);
        List pkg1Collection = this.underTest.getCollectionsForNode((Node)pkg1.adaptTo(Node.class));
        this.assertResourceCollections(pkg1Collection, "cq:Page", this.samplePage1.getPath());
        this.assertResourceCollections(pkg1Collection, "dam:Asset", this.sampleAsset.getPath());
        List pkg2Collection = this.underTest.getCollectionsForNode((Node)pkg2.adaptTo(Node.class));
        this.assertResourceCollections(pkg2Collection, "cq:Page", this.samplePage2.getPath());
        this.assertResourceCollections(pkg2Collection, "dam:Asset", new String[0]);
        List allCollection = this.underTest.getCollectionsForNode((Node)all.adaptTo(Node.class));
        this.assertResourceCollections(allCollection, "cq:Page", this.samplePage1.getPath(), this.samplePage2.getPath());
        this.assertResourceCollections(allCollection, "dam:Asset", this.sampleAsset.getPath());
    }

    private void createPackage(String path, String ... filterPaths) {
        Resource page = this.context.create().resource(path, new Object[]{"jcr:primaryType", "cq:Page"});
        Resource pageContent = this.context.create().resource(page, "jcr:content", new Object[]{"jcr:primaryType", "cq:PageContent"});
        Resource vltDef = this.context.create().resource(pageContent, "vlt:definition", new Object[]{"jcr:primaryType", "vlt:PackageDefinition"});
        for (int i = 0; i < filterPaths.length; ++i) {
            this.context.create().resource(vltDef, "filter/item" + i, new Object[]{"root", filterPaths[i]});
        }
    }

    private void assertPaths(List<Node> nodes, String ... paths) throws RepositoryException {
        ArrayList<String> nodePaths = new ArrayList<String>();
        for (Node node : nodes) {
            nodePaths.add(node.getPath());
        }
        Assert.assertEquals(List.of(paths), nodePaths);
    }

    private void assertResourceCollections(List<ResourceCollection> resourceCollections, String nodeType, String ... paths) throws RepositoryException {
        ArrayList<String> nodePaths = new ArrayList<String>();
        for (ResourceCollection resourceCollection : resourceCollections) {
            for (Node node : resourceCollection.list(new String[]{nodeType})) {
                nodePaths.add(node.getPath());
            }
        }
        Assert.assertEquals(List.of(paths), nodePaths);
    }
}

